/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.internal;

import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadConfig;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadRegistry;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.RegistryStore;
import io.github.resilience4j.core.registry.AbstractRegistry;
import io.github.resilience4j.core.registry.InMemoryRegistryStore;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.vavr.collection.Array;
import io.vavr.collection.HashMap;
import io.vavr.collection.Seq;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public final class InMemoryThreadPoolBulkheadRegistry
extends AbstractRegistry<ThreadPoolBulkhead, ThreadPoolBulkheadConfig>
implements ThreadPoolBulkheadRegistry {
    public InMemoryThreadPoolBulkheadRegistry() {
        this((io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    public InMemoryThreadPoolBulkheadRegistry(io.vavr.collection.Map<String, String> tags) {
        this(ThreadPoolBulkheadConfig.ofDefaults(), tags);
    }

    public InMemoryThreadPoolBulkheadRegistry(Map<String, ThreadPoolBulkheadConfig> configs) {
        this(configs, (io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    public InMemoryThreadPoolBulkheadRegistry(Map<String, ThreadPoolBulkheadConfig> configs, io.vavr.collection.Map<String, String> tags) {
        this(configs.getOrDefault("default", ThreadPoolBulkheadConfig.ofDefaults()), tags);
        this.configurations.putAll(configs);
    }

    public InMemoryThreadPoolBulkheadRegistry(Map<String, ThreadPoolBulkheadConfig> configs, RegistryEventConsumer<ThreadPoolBulkhead> registryEventConsumer) {
        this(configs, registryEventConsumer, (io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    public InMemoryThreadPoolBulkheadRegistry(Map<String, ThreadPoolBulkheadConfig> configs, RegistryEventConsumer<ThreadPoolBulkhead> registryEventConsumer, io.vavr.collection.Map<String, String> tags) {
        this(configs.getOrDefault("default", ThreadPoolBulkheadConfig.ofDefaults()), registryEventConsumer, tags);
        this.configurations.putAll(configs);
    }

    public InMemoryThreadPoolBulkheadRegistry(Map<String, ThreadPoolBulkheadConfig> configs, List<RegistryEventConsumer<ThreadPoolBulkhead>> registryEventConsumers) {
        this(configs, registryEventConsumers, (io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    public InMemoryThreadPoolBulkheadRegistry(Map<String, ThreadPoolBulkheadConfig> configs, List<RegistryEventConsumer<ThreadPoolBulkhead>> registryEventConsumers, io.vavr.collection.Map<String, String> tags) {
        this(configs.getOrDefault("default", ThreadPoolBulkheadConfig.ofDefaults()), registryEventConsumers, tags);
        this.configurations.putAll(configs);
    }

    public InMemoryThreadPoolBulkheadRegistry(ThreadPoolBulkheadConfig defaultConfig) {
        super(defaultConfig);
    }

    public InMemoryThreadPoolBulkheadRegistry(ThreadPoolBulkheadConfig defaultConfig, io.vavr.collection.Map<String, String> tags) {
        super(defaultConfig, tags);
    }

    public InMemoryThreadPoolBulkheadRegistry(ThreadPoolBulkheadConfig defaultConfig, RegistryEventConsumer<ThreadPoolBulkhead> registryEventConsumer) {
        super(defaultConfig, registryEventConsumer);
    }

    public InMemoryThreadPoolBulkheadRegistry(ThreadPoolBulkheadConfig defaultConfig, RegistryEventConsumer<ThreadPoolBulkhead> registryEventConsumer, io.vavr.collection.Map<String, String> tags) {
        super(defaultConfig, registryEventConsumer, tags);
    }

    public InMemoryThreadPoolBulkheadRegistry(ThreadPoolBulkheadConfig defaultConfig, List<RegistryEventConsumer<ThreadPoolBulkhead>> registryEventConsumers) {
        super(defaultConfig, registryEventConsumers);
    }

    public InMemoryThreadPoolBulkheadRegistry(ThreadPoolBulkheadConfig defaultConfig, List<RegistryEventConsumer<ThreadPoolBulkhead>> registryEventConsumers, io.vavr.collection.Map<String, String> tags) {
        super(defaultConfig, registryEventConsumers, tags);
    }

    public InMemoryThreadPoolBulkheadRegistry(Map<String, ThreadPoolBulkheadConfig> configs, List<RegistryEventConsumer<ThreadPoolBulkhead>> registryEventConsumers, io.vavr.collection.Map<String, String> tags, RegistryStore<ThreadPoolBulkhead> registryStore) {
        super(configs.getOrDefault("default", ThreadPoolBulkheadConfig.ofDefaults()), registryEventConsumers, Optional.ofNullable(tags).orElse(HashMap.empty()), Optional.ofNullable(registryStore).orElse(new InMemoryRegistryStore()));
        this.configurations.putAll(configs);
    }

    @Override
    public Seq<ThreadPoolBulkhead> getAllBulkheads() {
        return Array.ofAll(this.entryMap.values());
    }

    @Override
    public ThreadPoolBulkhead bulkhead(String name) {
        return this.bulkhead(name, HashMap.empty());
    }

    @Override
    public ThreadPoolBulkhead bulkhead(String name, io.vavr.collection.Map<String, String> tags) {
        return this.bulkhead(name, (ThreadPoolBulkheadConfig)this.getDefaultConfig(), tags);
    }

    @Override
    public ThreadPoolBulkhead bulkhead(String name, ThreadPoolBulkheadConfig config) {
        return this.bulkhead(name, config, HashMap.empty());
    }

    @Override
    public ThreadPoolBulkhead bulkhead(String name, ThreadPoolBulkheadConfig config, io.vavr.collection.Map<String, String> tags) {
        return this.computeIfAbsent(name, () -> ThreadPoolBulkhead.of(name, Objects.requireNonNull(config, "Config must not be null"), this.getAllTags(tags)));
    }

    @Override
    public ThreadPoolBulkhead bulkhead(String name, Supplier<ThreadPoolBulkheadConfig> bulkheadConfigSupplier) {
        return this.bulkhead(name, bulkheadConfigSupplier, HashMap.empty());
    }

    @Override
    public ThreadPoolBulkhead bulkhead(String name, Supplier<ThreadPoolBulkheadConfig> bulkheadConfigSupplier, io.vavr.collection.Map<String, String> tags) {
        return this.computeIfAbsent(name, () -> ThreadPoolBulkhead.of(name, Objects.requireNonNull((ThreadPoolBulkheadConfig)Objects.requireNonNull(bulkheadConfigSupplier, "Supplier must not be null").get(), "Config must not be null"), this.getAllTags(tags)));
    }

    @Override
    public ThreadPoolBulkhead bulkhead(String name, String configName) {
        return this.bulkhead(name, configName, HashMap.empty());
    }

    @Override
    public ThreadPoolBulkhead bulkhead(String name, String configName, io.vavr.collection.Map<String, String> tags) {
        return this.computeIfAbsent(name, () -> ThreadPoolBulkhead.of(name, (ThreadPoolBulkheadConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName)), this.getAllTags(tags)));
    }

    @Override
    public void close() throws Exception {
        for (ThreadPoolBulkhead bulkhead : this.getAllBulkheads()) {
            bulkhead.close();
        }
    }
}

