package io.sendon.sms.response;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;

public class SendRepeat extends SendonResponse {
  public SendRepeatData data;

  public static class SendRepeatData {
    public String groupId;
    public int succeeded;
    public int failed;
  }

  public SendRepeat(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    if (this.code != 200) return;

    this.data = new SendRepeatData();
    this.data.groupId = getStringValue(sendonJsonResponse.dataJson, "groupId");
    this.data.succeeded = getIntValue(sendonJsonResponse.dataJson, "succeeded");
    this.data.failed = getIntValue(sendonJsonResponse.dataJson, "failed");
  }
}
