package io.sendon.sms.response;

import java.util.ArrayList;
import java.util.List;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;

public class GetRepeats extends SendonResponse{
  public GetRepeatsData data;

  public enum RepeatStatus {
    RESERVED("RESERVED"),
    PROCESSING("PROCESSING"),
    COMPLETED("COMPLETED"),
    FAILED("FAILED"),
    CANCELED("CANCELED");

    public final String repeatStatus;

    RepeatStatus(String repeatStatus) {
      this.repeatStatus = repeatStatus;
    }
  }

  public static class RepeatItem {
    public String groupId;
    public String repeatId;
    public RepeatStatus repeatStatus;
    public String cancelRequestTime;
    public String cancelRequestIp;
    public String cancelTime;
    public String repeatSendTime;
    public int messageCount;
    public int standbyCount;
    public int succeededCount;
    public int failedCount;
    public int canceledCount;
    public int sendingCount;
  }

  public static class GetRepeatsData {
    public List<RepeatItem> repeats;
    public String cursor;

    public GetRepeatsData() {
      this.repeats = new ArrayList<>();
      this.cursor = "";
    }
  }


  public GetRepeats(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    if (this.code != 200) return;

    this.data = new GetRepeatsData();
    this.data.cursor = getStringValue(sendonJsonResponse.dataJson, "cursor");

    for (JsonElement element : sendonJsonResponse.dataJson.getAsJsonArray("items")) {
      this.data.repeats.add(parseRepeatItem(element.getAsJsonObject()));
    }
  }

  private RepeatItem parseRepeatItem(JsonObject item) {
    RepeatItem listItem = new RepeatItem();

    listItem.groupId = getStringValue(item, "groupId");
    listItem.repeatId = getStringValue(item, "repeatId");
    listItem.repeatStatus = getEnumValue(item, "repeatStatus", RepeatStatus.class);
    listItem.cancelRequestTime = getStringValue(item, "cancelRequestTime");
    listItem.cancelRequestIp = getStringValue(item, "cancelRequestIp");
    listItem.cancelTime = getStringValue(item, "cancelTime");
    listItem.repeatSendTime = getStringValue(item, "repeatSendTime");
    listItem.messageCount = getIntValue(item, "messagesCount");
    listItem.standbyCount = getIntValue(item, "standbyCount");
    listItem.succeededCount = getIntValue(item, "succeededCount");
    listItem.failedCount = getIntValue(item, "failedCount");
    listItem.canceledCount = getIntValue(item, "canceledCount");
    listItem.sendingCount = getIntValue(item, "sendingCount");

    return listItem;
  }
}
