package io.sendon.sms.response;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;

public class CancelRepeat extends SendonResponse {
  public CancelRepeatData data;

  public static class CancelRepeatData {
    public String groupId;
    public int succeeded;
    public int failed;
  }

  public CancelRepeat(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    if (this.code != 200) return;

    this.data = new CancelRepeatData();
    this.data.groupId = getStringValue(sendonJsonResponse.dataJson, "groupId");
    this.data.succeeded = getIntValue(sendonJsonResponse.dataJson, "succeeded");
    this.data.failed = getIntValue(sendonJsonResponse.dataJson, "failed");
  }
}
