package io.sendon.sms.request;

import java.util.List;

/**
 * Builder class for constructing SMS message details.
 */
public class SmsBuilder {
  public String from;
  public List<?> to;
  public String message;
  public boolean isAd;
  public Reservation reservation;

  /**
   * Sets the sender's phone number.
   *
   * @param from The sender's phone number.
   * @return The current instance of {@link SmsBuilder}.
   */
  public SmsBuilder setFrom(String from) {
    this.from = from;
    return this;
  }

  /**
   * Sets the list of recipients.
   *
   * @param to The list of recipients. Can be {@code List<String>}, {@code List<ToWithName>}, or {@code List<ToWithBucket>}.
   * @return The current instance of {@link SmsBuilder}.
   */
  public SmsBuilder setTo(List<?> to) {
    this.to = to;
    return this;
  }

  /**
   * Sets the message content.
   *
   * @param message The message content.
   * @return The current instance of {@link SmsBuilder}.
   */
  public SmsBuilder setMessage(String message) {
    this.message = message;
    return this;
  }

  /**
   * Sets whether the message is an advertisement.
   *
   * @param isAd {@code true} if the message is an advertisement, otherwise {@code false}.
   * @return The current instance of {@link SmsBuilder}.
   */
  public SmsBuilder setIsAd(boolean isAd) {
    this.isAd = isAd;
    return this;
  }

  /**
   * Sets the reservation details for scheduling.
   *
   * @param reservation The reservation details.
   * @return The current instance of {@link SmsBuilder}.
   */
  public SmsBuilder setReservation(Reservation reservation) {
    this.reservation = reservation;
    return this;
  }
}
