package io.sendon.sms.request;

/**
 * Represents the reservation details for scheduling a message.
 */
public class Reservation {
  public String datetime;
  public Repeat repeat;

  /**
   * Constructs a {@link Reservation} instance with the specified datetime.
   *
   * @param datetime The datetime for the reservation.
   */
  public Reservation(String datetime) {
    this.datetime = datetime;
  }

  /**
   * Sets the repeat configuration for the reservation.
   *
   * @param repeat The repeat configuration.
   * @return The current instance of {@link Reservation}.
   */
  public Reservation setRepeat(Repeat repeat) {
    this.repeat = repeat;
    return this;
  }
}
