package io.sendon.sms.request;

/**
 * Represents the repeat configuration for a scheduled message.
 */
public class Repeat {

  public enum RepeatUnit {
    MINUTE("MINUTE"),
    HOUR("HOUR"),
    DAY("DAY");

    public final String value;

    RepeatUnit(String repeatUnit) {
      this.value = repeatUnit;
    }
  }

  public int messageCount;
  public RepeatUnit unit;
  public int interval;
  public boolean denyNightTime;

  /**
   * Default constructor for {@link Repeat}.
   */
  public Repeat() {
    this.messageCount = 0;
    this.unit = RepeatUnit.MINUTE;
    this.interval = 0;
    this.denyNightTime = false;
  }

  /**
   * Constructs a {@link Repeat} instance with the specified parameters.
   *
   * @param messageCount  The number of messages to send.
   * @param unit          The unit of time for the interval.
   * @param interval      The interval between messages.
   * @param denyNightTime Whether to deny sending messages at night.
   */
  public Repeat(int messageCount, RepeatUnit unit, int interval, boolean denyNightTime) {
    this.messageCount = messageCount;
    this.unit = unit;
    this.interval = interval;
    this.denyNightTime = denyNightTime;
  }

  /**
   * Sets the number of messages to send.
   *
   * @param messageCount The number of messages.
   * @return The current instance of {@link Repeat}.
   */
  public Repeat setMessageCount(int messageCount) {
    this.messageCount = messageCount;
    return this;
  }

  /**
   * Sets the unit of time for the interval.
   *
   * @param unit The unit of time.
   * @return The current instance of {@link Repeat}.
   */
  public Repeat setUnit(RepeatUnit unit) {
    this.unit = unit;
    return this;
  }

  /**
   * Sets the interval between messages.
   *
   * @param interval The interval.
   * @return The current instance of {@link Repeat}.
   */
  public Repeat setInterval(int interval) {
    this.interval = interval;
    return this;
  }

  /**
   * Sets whether to deny sending messages at night.
   *
   * @param denyNightTime {@code true} to deny sending at night, otherwise {@code false}.
   * @return The current instance of {@link Repeat}.
   */
  public Repeat setDenyNightTime(boolean denyNightTime) {
    this.denyNightTime = denyNightTime;
    return this;
  }
}
