package io.sendon.sms.request;

import java.util.List;

/**
 * Builder class for constructing MMS message details.
 */
public class MmsBuilder {
  public String from;
  public List<?> to;
  public String title;
  public String message;
  public boolean isAd;
  public Reservation reservation;
  public List<String> images;

  /**
   * Sets the sender's phone number.
   *
   * @param from The sender's phone number.
   * @return The current instance of {@link MmsBuilder}.
   */
  public MmsBuilder setFrom(String from) {
    this.from = from;
    return this;
  }

  /**
   * Sets the list of recipients.
   *
   * @param to The list of recipients. Can be {@code List<String>}, {@code List<ToWithName>}, or {@code List<ToWithBucket>}.
   * @return The current instance of {@link MmsBuilder}.
   */
  public MmsBuilder setTo(List<?> to) {
    this.to = to;
    return this;
  }

  /**
   * Sets the title of the message.
   *
   * @param title The title of the message.
   * @return The current instance of {@link MmsBuilder}.
   */
  public MmsBuilder setTitle(String title) {
    this.title = title;
    return this;
  }

  /**
   * Sets the message content.
   *
   * @param message The message content.
   * @return The current instance of {@link MmsBuilder}.
   */
  public MmsBuilder setMessage(String message) {
    this.message = message;
    return this;
  }

  /**
   * Sets whether the message is an advertisement.
   *
   * @param isAd {@code true} if the message is an advertisement, otherwise {@code false}.
   * @return The current instance of {@link MmsBuilder}.
   */
  public MmsBuilder setIsAd(boolean isAd) {
    this.isAd = isAd;
    return this;
  }

  /**
   * Sets the reservation details for scheduling.
   *
   * @param reservation The reservation details.
   * @return The current instance of {@link MmsBuilder}.
   */
  public MmsBuilder setReservation(Reservation reservation) {
    this.reservation = reservation;
    return this;
  }

  /**
   * Sets the list of image URLs to include in the MMS.
   *
   * @param images The list of image URLs.
   * @return The current instance of {@link MmsBuilder}.
   */
  public MmsBuilder setImages(List<String> images) {
    this.images = images;
    return this;
  }
}
