package io.sendon.sender.response;

import java.util.ArrayList;
import java.util.List;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;

public class GetUserNumbers extends SendonResponse {
  public GetUserNumbersData data;

  public enum NumberType {
    MOBILE("MOBILE"),
    LANDLINE("LANDLINE");

    public final String numberType;

    NumberType(String numberType) {
      this.numberType = numberType;
    }
  }

  public enum SenderStatus {
    REGISTERED("REGISTERED"),
    WAITING("WAITING"),
    ACTIVE("ACTIVE"),
    INPROGRESS("INPROGRESS"),
    SUSPENDED("SUSPENDED"),
    DENIED("DENIED"),
    REJECTED("REJECTED"),
    FREE("FREE"),
    EXPIRED("EXPIRED");

    public final String senderStatus;

    SenderStatus(String senderStatus) {
      this.senderStatus = senderStatus;
    }
  }

  public enum RejectType {
    DOCS("DOCS"),
    REOPEN("REOPEN"),
    NONE("");

    public final String rejectType;

    RejectType(String rejectType) {
      this.rejectType = rejectType;
    }
  }

  public enum YorN {
    Y("Y"),
    N("N");

    public final String yOrN;

    YorN(String yOrN) {
      this.yOrN = yOrN;
    }
  }

  public enum ContractorType {
    COMPANY("COMPANY"),
    COMPANY_EMPLOYEE("COMPANY_EMPLOYEE"),
    COMPANY_CEO("COMPANY_CEO"),
    OTHER_COMPANY("OTHER_COMPANY");

    public final String contractorType;

    ContractorType(String contractorType) {
      this.contractorType = contractorType;
    }
  }

  public static class GetUserNumberItem {
    int numberId;
    int userId;
    int channelId;
    String senderNumber;
    NumberType numberType;
    SenderStatus senderStatus;
    RejectType rejectType;
    boolean isDefault;
    String displayName;
    boolean isDuplicatedNumber;
    ContractorType numberContractorType;
    int companyId;
    String companyName;
    boolean isHidden;
    String createdAt;
    String updatedAt;
  }

  public static class GetUserNumbersData {
    List<GetUserNumberItem> list;
  }

  public GetUserNumbers(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    if (this.code != 200) return;

    GetUserNumbersData data = new GetUserNumbersData();
    List<GetUserNumberItem> userNumberList = new ArrayList<>();

    for (JsonElement element : sendonJsonResponse.dataJson.getAsJsonArray("list")) {
      JsonObject item = element.getAsJsonObject();
      userNumberList.add(parseUserNumberItem(item));
    }

    data.list = userNumberList;
    this.data = data;
  }

  private GetUserNumberItem parseUserNumberItem(JsonObject item) {
    GetUserNumberItem listItem = new GetUserNumberItem();

    listItem.numberId = getIntValue(item, "numberId");
    listItem.userId = getIntValue(item, "userId");
    listItem.channelId = getIntValue(item, "channelId");
    listItem.senderNumber = getStringValue(item, "senderNumber");
    listItem.numberType = getEnumValue(item, "numberType", NumberType.class);
    listItem.senderStatus = getEnumValue(item, "senderStatus", SenderStatus.class);
    listItem.rejectType = getEnumValue(item, "rejectType", RejectType.class);
    listItem.isDefault = getBooleanValue(item, "isDefault", YorN.Y);
    listItem.displayName = getStringValue(item, "displayName");
    listItem.isDuplicatedNumber = getIntValue(item, "isDuplicatedNumber") == 1;
    listItem.numberContractorType = getEnumValue(item, "numberContractorType", ContractorType.class);
    listItem.companyId = getIntValue(item, "companyId");
    listItem.companyName = getStringValue(item, "companyName");
    listItem.isHidden = getBooleanValue(item, "isHidden", YorN.Y);
    listItem.createdAt = getStringValue(item, "createdAt");
    listItem.updatedAt = getStringValue(item, "updatedAt");
    return listItem;
  }

}