package io.sendon.sender;

import io.sendon.Log;
import io.sendon.base.SendonClient;
import io.sendon.base.SendonJsonResponse;
import io.sendon.sender.response.GetUserNumbers;

/**
 * SendonSender is a client wrapper for interacting with the Sendon API.
 * It provides methods to perform operations such as fetching user numbers.
 */
public class SendonSender extends SendonClient {

  /**
   * Constructor to initialize SendonSender with user credentials.
   *
   * @param userId The user ID for authentication.
   * @param apiKey The API key for authentication.
   */
  public SendonSender(String userId, String apiKey) {
    super(userId, apiKey);
  }

  /**
   * Constructor to initialize SendonSender with user credentials and an option to use OkHttp.
   *
   * @param userId The user ID for authentication.
   * @param apiKey The API key for authentication.
   * @param useOkHttp Flag to indicate whether to use OkHttp for HTTP requests.
   */
  public SendonSender(String userId, String apiKey, boolean useOkHttp) {
    super(userId, apiKey, useOkHttp);
  }

  /**
   * Fetches a paginated list of user numbers from the Sendon API.
   *
   * @param cursor The starting point for pagination.
   * @param limit The maximum number of results to fetch.
   * @return A GetUserNumbers object containing the response data, or null if an error occurs.
   */
  public GetUserNumbers getUserNumbers(int cursor, int limit) {
    Log.d("getUserNumbers: cursor=" + cursor + ", limit=" + limit);

    try {
      SendonJsonResponse sendonJsonResponse = parseJsonResponse(get("/v2/sender/numbers?cursor=" + cursor + "&limit=" + limit));
      return new GetUserNumbers(sendonJsonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }
}
