package io.sendon.rcs.response;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;
import io.sendon.rcs.SendonRcs.MessageType;

public class GetRcs extends SendonResponse {
  public GetRcsData data;

  public enum GroupStatus {
    NONE("NONE"),
    RESERVED("RESERVED"),
    PROCESSING("PROCESSING"),
    COMPLETED("COMPLETED"),
    FAILED("FAILED"),
    CANCELED("CANCELED");

    public final String value;

    GroupStatus(String groupStatus) {
      this.value = groupStatus;
    }
  }

  public static class GetRcsData {
    public String groupId;
    public String channelId;
    public int countRequest;
    public String message;
    public MessageType messageType;
    public String requestIp;
    public int userId;
    public boolean isUseApi;
    public int messageCount;
    public int standbyCount;
    public int sendingCount;
    public int succeededCount;
    public int failedCount;
    public int canceledCount;
    public int blockedCount;
    public int pointId;
    public float totalPoint;
    public float vatPoint;
    public float unitCost;
    public float refundPoint;
    public GroupStatus groupStatus;
    public String createdAt;
    public String senderNumber;
  }

  public GetRcs(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    if (this.code != 200) return;

    this.data = new GetRcsData();
    this.data.groupId = getStringValue(sendonJsonResponse.dataJson, "groupId");
    this.data.channelId = getStringValue(sendonJsonResponse.dataJson, "channelId");
    this.data.countRequest = getIntValue(sendonJsonResponse.dataJson, "countRequest");
    this.data.message = getStringValue(sendonJsonResponse.dataJson, "message");

    String messageTypeStr = getStringValue(sendonJsonResponse.dataJson, "messageType");
    if (messageTypeStr != null) {
      for (MessageType type : MessageType.values()) {
        if (type.value.equals(messageTypeStr)) {
          this.data.messageType = type;
          break;
        }
      }
    }

    this.data.requestIp = getStringValue(sendonJsonResponse.dataJson, "requestIp");
    this.data.userId = getIntValue(sendonJsonResponse.dataJson, "userId");
    this.data.isUseApi = getBooleanValue(sendonJsonResponse.dataJson, "isUseApi");
    this.data.messageCount = getIntValue(sendonJsonResponse.dataJson, "messageCount");
    this.data.standbyCount = getIntValue(sendonJsonResponse.dataJson, "standbyCount");
    this.data.sendingCount = getIntValue(sendonJsonResponse.dataJson, "sendingCount");
    this.data.succeededCount = getIntValue(sendonJsonResponse.dataJson, "succeededCount");
    this.data.failedCount = getIntValue(sendonJsonResponse.dataJson, "failedCount");
    this.data.canceledCount = getIntValue(sendonJsonResponse.dataJson, "canceledCount");
    this.data.blockedCount = getIntValue(sendonJsonResponse.dataJson, "blockedCount");
    this.data.pointId = getIntValue(sendonJsonResponse.dataJson, "pointId");
    this.data.totalPoint = getFloatValue(sendonJsonResponse.dataJson, "totalPoint");
    this.data.vatPoint = getFloatValue(sendonJsonResponse.dataJson, "vatPoint");
    this.data.unitCost = getFloatValue(sendonJsonResponse.dataJson, "unitCost");
    this.data.refundPoint = getFloatValue(sendonJsonResponse.dataJson, "refundPoint");

    String groupStatusStr = getStringValue(sendonJsonResponse.dataJson, "groupStatus");
    if (groupStatusStr != null) {
      for (GroupStatus status : GroupStatus.values()) {
        if (status.value.equals(groupStatusStr)) {
          this.data.groupStatus = status;
          break;
        }
      }
    }

    this.data.createdAt = getStringValue(sendonJsonResponse.dataJson, "createdAt");
    this.data.senderNumber = getStringValue(sendonJsonResponse.dataJson, "senderNumber");
  }
}