package io.sendon.rcs.request;

import java.util.List;

import io.sendon.rcs.SendonRcs.MessageType;

/**
 * Builder class for constructing RCS message details.
 */
public class RcsBuilder {
  public MessageType type;
  public String from;
  public List<String> to;
  public RbcConfig rbcConfig;
  public Boolean useCredit;
  public Boolean useFallback;
  public Fallback fallback;

  /**
   * Sets the RCS message type.
   *
   * @param type The RCS message type (RcsTSM, RcsTLM, RcsTMM).
   * @return The current instance of {@link RcsBuilder}.
   */
  public RcsBuilder setType(MessageType type) {
    this.type = type;
    return this;
  }

  /**
   * Sets the sender's phone number.
   *
   * @param from The sender's phone number.
   * @return The current instance of {@link RcsBuilder}.
   */
  public RcsBuilder setFrom(String from) {
    this.from = from;
    return this;
  }

  /**
   * Sets the list of recipient phone numbers.
   *
   * @param to The list of recipient phone numbers.
   * @return The current instance of {@link RcsBuilder}.
   */
  public RcsBuilder setTo(List<String> to) {
    this.to = to;
    return this;
  }

  /**
   * Sets the RCS business configuration.
   *
   * @param rbcConfig The RCS business configuration.
   * @return The current instance of {@link RcsBuilder}.
   */
  public RcsBuilder setRbcConfig(RbcConfig rbcConfig) {
    this.rbcConfig = rbcConfig;
    return this;
  }

  /**
   * Sets whether to use credit for sending.
   *
   * @param useCredit Whether to use credit for sending.
   * @return The current instance of {@link RcsBuilder}.
   */
  public RcsBuilder setUseCredit(Boolean useCredit) {
    this.useCredit = useCredit;
    return this;
  }

  /**
   * Sets whether to use fallback SMS when RCS fails.
   *
   * @param useFallback Whether to use fallback SMS when RCS fails.
   * @return The current instance of {@link RcsBuilder}.
   */
  public RcsBuilder setUseFallback(Boolean useFallback) {
    this.useFallback = useFallback;
    return this;
  }

  /**
   * Sets the fallback message configuration.
   *
   * @param fallback The fallback message configuration.
   * @return The current instance of {@link RcsBuilder}.
   */
  public RcsBuilder setFallback(Fallback fallback) {
    this.fallback = fallback;
    return this;
  }
}