package io.sendon.rcs.request;

import com.google.gson.JsonObject;

public class RbcConfig {
  private String chatbotId;
  private String messagebaseId;
  private Integer header;
  private String footer;
  private Integer expiryOption;
  private Boolean copyAllowed;
  private String brandId;
  private String brandKey;
  private String agencyId;
  private String agencyKey;
  private String campaignId;
  private String osc;
  private RbcBody body;
  private String clientId;
  private String clientSecret;

  public static class RbcBody {
    public String description;

    public JsonObject toJson() {
      JsonObject json = new JsonObject();
      if (description != null) {
        json.addProperty("description", description);
      }
      return json;
    }
  }

  public RbcConfig setChatbotId(String chatbotId) {
    this.chatbotId = chatbotId;
    return this;
  }

  public RbcConfig setMessagebaseId(String messagebaseId) {
    this.messagebaseId = messagebaseId;
    return this;
  }

  public RbcConfig setHeader(Integer header) {
    this.header = header;
    return this;
  }

  public RbcConfig setFooter(String footer) {
    this.footer = footer;
    return this;
  }

  public RbcConfig setExpiryOption(Integer expiryOption) {
    this.expiryOption = expiryOption;
    return this;
  }

  public RbcConfig setCopyAllowed(Boolean copyAllowed) {
    this.copyAllowed = copyAllowed;
    return this;
  }

  public RbcConfig setBrandId(String brandId) {
    this.brandId = brandId;
    return this;
  }

  public RbcConfig setBrandKey(String brandKey) {
    this.brandKey = brandKey;
    return this;
  }

  public RbcConfig setAgencyId(String agencyId) {
    this.agencyId = agencyId;
    return this;
  }

  public RbcConfig setAgencyKey(String agencyKey) {
    this.agencyKey = agencyKey;
    return this;
  }

  public RbcConfig setCampaignId(String campaignId) {
    this.campaignId = campaignId;
    return this;
  }

  public RbcConfig setOsc(String osc) {
    this.osc = osc;
    return this;
  }

  public RbcConfig setBody(RbcBody body) {
    this.body = body;
    return this;
  }

  public RbcConfig setClientId(String clientId) {
    this.clientId = clientId;
    return this;
  }

  public RbcConfig setClientSecret(String clientSecret) {
    this.clientSecret = clientSecret;
    return this;
  }

  public JsonObject toJson() {
    JsonObject json = new JsonObject();

    if (chatbotId != null) {
      json.addProperty("chatbotId", chatbotId);
    }
    if (messagebaseId != null) {
      json.addProperty("messagebaseId", messagebaseId);
    }
    if (header != null) {
      json.addProperty("header", header);
    }
    if (footer != null) {
      json.addProperty("footer", footer);
    }
    if (expiryOption != null) {
      json.addProperty("expiryOption", expiryOption);
    }
    if (copyAllowed != null) {
      json.addProperty("copyAllowed", copyAllowed);
    }
    if (brandId != null) {
      json.addProperty("brandId", brandId);
    }
    if (brandKey != null) {
      json.addProperty("brandKey", brandKey);
    }
    if (agencyId != null) {
      json.addProperty("agencyId", agencyId);
    }
    if (agencyKey != null) {
      json.addProperty("agencyKey", agencyKey);
    }
    if (campaignId != null) {
      json.addProperty("campaignId", campaignId);
    }
    if (osc != null) {
      json.addProperty("osc", osc);
    }
    if (body != null) {
      json.add("body", body.toJson());
    }
    if (clientId != null) {
      json.addProperty("clientId", clientId);
    }
    if (clientSecret != null) {
      json.addProperty("clientSecret", clientSecret);
    }

    return json;
  }
}