package io.sendon.rcs.request;

import java.util.List;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

public class Fallback {
  private String messageType;
  private String from;
  private List<String> images;
  private Boolean isAd;
  private String title;
  private String message;
  private String advertiserName;
  private BlockCall blockCall;

  public static class BlockCall {
    public String numberOf080;
    public String pinNumber;

    public JsonObject toJson() {
      JsonObject json = new JsonObject();
      if (numberOf080 != null) {
        json.addProperty("numberOf080", numberOf080);
      }
      if (pinNumber != null) {
        json.addProperty("pinNumber", pinNumber);
      }
      return json;
    }
  }

  public Fallback setMessageType(String messageType) {
    this.messageType = messageType;
    return this;
  }

  public Fallback setFrom(String from) {
    this.from = from;
    return this;
  }

  public Fallback setImages(List<String> images) {
    this.images = images;
    return this;
  }

  public Fallback setIsAd(Boolean isAd) {
    this.isAd = isAd;
    return this;
  }

  public Fallback setTitle(String title) {
    this.title = title;
    return this;
  }

  public Fallback setMessage(String message) {
    this.message = message;
    return this;
  }

  public Fallback setAdvertiserName(String advertiserName) {
    this.advertiserName = advertiserName;
    return this;
  }

  public Fallback setBlockCall(BlockCall blockCall) {
    this.blockCall = blockCall;
    return this;
  }

  public JsonObject toJson() {
    JsonObject json = new JsonObject();

    if (messageType != null) {
      json.addProperty("messageType", messageType);
    }
    if (from != null) {
      json.addProperty("from", from);
    }
    if (images != null && !images.isEmpty()) {
      JsonArray imagesArray = new JsonArray();
      for (String image : images) {
        imagesArray.add(image);
      }
      json.add("images", imagesArray);
    }
    if (isAd != null) {
      json.addProperty("isAd", isAd);
    }
    if (title != null) {
      json.addProperty("title", title);
    }
    if (message != null) {
      json.addProperty("message", message);
    }
    if (advertiserName != null) {
      json.addProperty("advertiserName", advertiserName);
    }
    if (blockCall != null) {
      json.add("blockCall", blockCall.toJson());
    }

    return json;
  }
}