package io.sendon.point;

import io.sendon.Log;
import io.sendon.base.SendonClient;
import io.sendon.base.SendonJsonResponse;
import io.sendon.point.response.GetCosts;
import io.sendon.point.response.GetPoints;

/**
 * SendonPoint is a client wrapper for interacting with the Sendon API.
 * It provides methods to retrieve point-related information such as points and costs.
 */
public class SendonPoint extends SendonClient {

  /**
   * Constructor to initialize SendonPoint with user credentials.
   *
   * @param userId The user ID for authentication.
   * @param apiKey The API key for authentication.
   */
  public SendonPoint(String userId, String apiKey) {
    super(userId, apiKey);
  }

  /**
   * Constructor to initialize SendonPoint with user credentials and an option to use OkHttp.
   *
   * @param userId The user ID for authentication.
   * @param apiKey The API key for authentication.
   * @param useOkHttp Flag to indicate whether to use OkHttp for HTTP requests.
   */
  public SendonPoint(String userId, String apiKey, boolean useOkHttp) {
    super(userId, apiKey, useOkHttp);
  }

  /**
   * Fetches the user's current points from the Sendon API.
   *
   * @return A GetPoints object containing the user's points, or null if an error occurs.
   */
  public GetPoints getPoints() {
    Log.d("getPoints");

    try {
      SendonJsonResponse sendonResponse = parseJsonResponse(get("/v2/point/points"));
      return new GetPoints(sendonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    // Return null if an exception occurs.
    return null;
  }

  /**
   * Fetches the cost details from the Sendon API.
   *
   * @return A GetCosts object containing the cost details, or null if an error occurs.
   */
  public GetCosts getCosts() {
    Log.d("getCost");

    try {
      SendonJsonResponse sendonResponse = parseJsonResponse(get("/v2/point/costs"));
      return new GetCosts(sendonResponse);
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }
}
