package io.sendon.kakao.response;

import java.util.ArrayList;
import java.util.List;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;

public class UploadFallbackImage extends SendonResponse {
  public UploadFallbackImageData data;

  public static class UploadFallbackImageData {
    public List<String> imageIds;
  }

  public UploadFallbackImage(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    if (this.code != 200) return;

    this.data = new UploadFallbackImageData();

    this.data.imageIds = new ArrayList<>();
    sendonJsonResponse.dataJson.getAsJsonArray("imageIds").forEach(item -> {
      this.data.imageIds.add(item.getAsString());
    });
  }

}


