package io.sendon.kakao.response;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;

public class SendGroup extends SendonResponse {
  public SendGroupData data;

  public static class SendGroupData {
    public int succeeded;
    public int failed;
  }

  public SendGroup(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    if (this.code != 200) return;

    this.data = new SendGroupData();
    this.data.succeeded = getIntValue(sendonJsonResponse.dataJson, "succeeded");
    this.data.failed = getIntValue(sendonJsonResponse.dataJson, "failed");
  }

}
