package io.sendon.kakao.response;

import java.lang.reflect.Type;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;

public class RegisterProfile extends SendonResponse {
  public RegisterProfileData data;

  public static class RegisterProfileData {
    public String id;
    public String channelId;
    public String channelName;
    public String status;
    public String profileStatus;
    public String updateBy;
    public boolean dormant;
    public boolean block;
    public String createdAt;
    public String updatedAt;
  }

  public RegisterProfile(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    if (this.code != 200) return;

    Type type = new TypeToken<RegisterProfileData>(){}.getType();
    this.data = new Gson().fromJson(sendonJsonResponse.dataJson, type);
  }
}
