package io.sendon.kakao.response;

import java.util.ArrayList;
import java.util.List;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;

public class GetProfiles extends SendonResponse {
  public GetProfilesData data;

  public static class SendProfiles {
    public String id;
    public String channelId;
    public String channelName;
    public String status;
    public String profileStatus;
    public String updateBy;
    public boolean dormant;
    public boolean block;
    public String createdAt;
    public String updatedAt;
  }

  public static class GetProfilesData {
    List<SendProfiles> sendProfiles;
    String nextCursor;

    public GetProfilesData() {
      this.sendProfiles = new ArrayList<>();
    }
  }

  public GetProfiles(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    if (this.code != 200) return;

    this.data = new GetProfilesData();
    this.data.nextCursor = getStringValue(sendonJsonResponse.dataJson, "nextCursor");

    sendonJsonResponse.dataJson.getAsJsonArray("sendProfiles").forEach(item -> {
      SendProfiles sendProfile = new SendProfiles();
      sendProfile.id = getStringValue(item.getAsJsonObject(), "id");
      sendProfile.channelId = getStringValue(item.getAsJsonObject(), "channelId");
      sendProfile.channelName = getStringValue(item.getAsJsonObject(), "channelName");
      sendProfile.status = getStringValue(item.getAsJsonObject(), "status");
      sendProfile.profileStatus = getStringValue(item.getAsJsonObject(), "profileStatus");
      sendProfile.updateBy = getStringValue(item.getAsJsonObject(), "updateBy");
      sendProfile.dormant = getBooleanValue(item.getAsJsonObject(), "dormant");
      sendProfile.block = getBooleanValue(item.getAsJsonObject(), "block");
      sendProfile.createdAt = getStringValue(item.getAsJsonObject(), "createdAt");
      sendProfile.updatedAt = getStringValue(item.getAsJsonObject(), "updatedAt");

      this.data.sendProfiles.add(sendProfile);
    });
  }
}
