package io.sendon.kakao.response;

import java.util.ArrayList;
import java.util.List;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;
import io.sendon.kakao.request.AlButton;
import io.sendon.kakao.request.Button;
import io.sendon.kakao.request.ButtonType;
import io.sendon.kakao.request.TemplateEmphasizeType;
import io.sendon.kakao.request.TemplateMessageType;
import io.sendon.kakao.request.TemplateStatus;
import io.sendon.kakao.request.WlButton;
import io.sendon.point.response.GetCosts.MessageType;

public class CreateTemplate extends SendonResponse {
  public CreateTemplateData data;

  public static class Fallback {
    public String senderNumber;
    public MessageType type;
    public String message;
    public String title;
    public List<String> images;
    public String groupId;

    public Fallback() {
      this.senderNumber = "";
      this.type = MessageType.SMS;
      this.message = "";
      this.title = "";
      this.images = new ArrayList<>();
      this.groupId = "";
    }
  }

  public static class TemplateComment {
    public String commentContent;
    public String commentCreateAt;
    public String commentSeqno;
    public String commentStatus;
    public String commentUserName;
    public String updateBy;
    public String updateDate;
  }

  public static class CreateTemplateData {
    public String profileId;
    public String id;
    public String templateName;
    public TemplateStatus status;
    public TemplateMessageType templateMessageType;
    public TemplateEmphasizeType templateEmphasizeType;
    public String templateContent;
    public List<Button> buttons;
    public Fallback fallback;
    public boolean securityFlag;
    public List<TemplateComment> templateComments;
    public String templateTitle;
    public String templateSubtitle;
    public String templateImageName;
    public String templateImageUrl;
    public String templateAd;
    public String templateExtra;
    public String createdAt;
    public String updatedAt;
    public String syncedAt;
    public String lastUsedAt;
  }

  public CreateTemplate(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    if (this.code != 200) return;

    this.data = new CreateTemplateData();
    this.data.profileId = getStringValue(sendonJsonResponse.dataJson, "profileId");
    this.data.id = getStringValue(sendonJsonResponse.dataJson, "id");
    this.data.templateName = getStringValue(sendonJsonResponse.dataJson, "templateName");
    this.data.status = getEnumValue(sendonJsonResponse.dataJson, "status", TemplateStatus.class);
    this.data.templateMessageType = getEnumValue(sendonJsonResponse.dataJson, "templateMessageType", TemplateMessageType.class);
    this.data.templateEmphasizeType = getEnumValue(sendonJsonResponse.dataJson, "templateEmphasizeType", TemplateEmphasizeType.class);
    this.data.templateContent = getStringValue(sendonJsonResponse.dataJson, "templateContent");
    this.data.buttons = new ArrayList<>();

    sendonJsonResponse.dataJson.getAsJsonArray("buttons").forEach(item -> {
      ButtonType buttonType = getEnumValue(item.getAsJsonObject(), "type", ButtonType.class);

      if (buttonType == ButtonType.WL) {
        WlButton button = new WlButton();
        button.type = buttonType;
        button.name = getStringValue(item.getAsJsonObject(), "name");
        button.ordering = getIntValue(item.getAsJsonObject(), "ordering");
        button.urlMobile = getStringValue(item.getAsJsonObject(), "urlMobile");
        button.urlPc = getStringValue(item.getAsJsonObject(), "urlPc");
        this.data.buttons.add(button);
      } else if (buttonType == ButtonType.AL) {
        AlButton button = new AlButton();
        button.type = buttonType;
        button.name = getStringValue(item.getAsJsonObject(), "name");
        button.ordering = getIntValue(item.getAsJsonObject(), "ordering");
        button.schemeIos = getStringValue(item.getAsJsonObject(), "schemeIos");
        button.schemeAndroid = getStringValue(item.getAsJsonObject(), "schemeAndroid");
        this.data.buttons.add(button);
      } else {
        Button button = new Button();
        button.type = buttonType;
        button.name = getStringValue(item.getAsJsonObject(), "name");
        button.ordering = getIntValue(item.getAsJsonObject(), "ordering");
        this.data.buttons.add(button);
      }
    });

    this.data.fallback = new Fallback();
    this.data.fallback.senderNumber = getStringValue(sendonJsonResponse.dataJson, "fallback.senderNumber");
    this.data.fallback.type = getEnumValue(sendonJsonResponse.dataJson, "fallback.type", MessageType.class);
    this.data.fallback.message = getStringValue(sendonJsonResponse.dataJson, "fallback.message");
    this.data.fallback.title = getStringValue(sendonJsonResponse.dataJson, "fallback.title");

    if (sendonJsonResponse.dataJson.has("fallback.images") &&
        sendonJsonResponse.dataJson.get("fallback.images").isJsonArray()) {
        sendonJsonResponse.dataJson.getAsJsonArray("fallback.images").forEach(item -> {
            this.data.fallback.images.add(getStringValue(item.getAsJsonObject(), "url"));
        });
    }

    this.data.fallback.groupId = getStringValue(sendonJsonResponse.dataJson, "fallback.groupId");
    this.data.securityFlag = getBooleanValue(sendonJsonResponse.dataJson, "securityFlag");
    this.data.templateComments = new ArrayList<>();

    if (sendonJsonResponse.dataJson.has("templateComments") &&
        sendonJsonResponse.dataJson.get("templateComments").isJsonArray()) {
        sendonJsonResponse.dataJson.getAsJsonArray("templateComments").forEach(item -> {
            TemplateComment templateComment = new TemplateComment();
            templateComment.commentContent = getStringValue(item.getAsJsonObject(), "commentContent");
            templateComment.commentCreateAt = getStringValue(item.getAsJsonObject(), "commentCreateAt");
            templateComment.commentSeqno = getStringValue(item.getAsJsonObject(), "commentSeqno");
            templateComment.commentStatus = getStringValue(item.getAsJsonObject(), "commentStatus");
            templateComment.commentUserName = getStringValue(item.getAsJsonObject(), "commentUserName");
            templateComment.updateBy = getStringValue(item.getAsJsonObject(), "updateBy");
            templateComment.updateDate = getStringValue(item.getAsJsonObject(), "updateDate");

            this.data.templateComments.add(templateComment);
        });
    }

    this.data.templateTitle = getStringValue(sendonJsonResponse.dataJson, "templateTitle");
    this.data.templateSubtitle = getStringValue(sendonJsonResponse.dataJson, "templateSubtitle");
    this.data.templateImageName = getStringValue(sendonJsonResponse.dataJson, "templateImageName");
    this.data.templateImageUrl = getStringValue(sendonJsonResponse.dataJson, "templateImageUrl");
    this.data.templateAd = getStringValue(sendonJsonResponse.dataJson, "templateAd");
    this.data.templateExtra = getStringValue(sendonJsonResponse.dataJson, "templateExtra");
    this.data.createdAt = getStringValue(sendonJsonResponse.dataJson, "createdAt");
    this.data.updatedAt = getStringValue(sendonJsonResponse.dataJson, "updatedAt");
    this.data.syncedAt = getStringValue(sendonJsonResponse.dataJson, "syncedAt");
    this.data.lastUsedAt = getStringValue(sendonJsonResponse.dataJson, "lastUsedAt");

  }
}
