package io.sendon.kakao.request;

import java.util.Map;

/**
 * Represents a recipient with variables for personalized messages.
 * Example JSON structure:
 * {
 *   "phone": "string",
 *   "variables": {
 *     "#{고객명}": "홍길동",
 *     "#{주문번호}": "1234567890"
 *   }
 * }
 */
public class ToWithVariable {
  private String phone; // The recipient's phone number.
  private Map<String, String> variables; // Variables for message personalization.

  public ToWithVariable(String phone, Map<String, String> variables) {
    this.phone = phone;
    this.variables = variables;
  }

  public String getPhone() {
    return phone;
  }

  public void setPhone(String phone) {
    this.phone = phone;
  }

  public Map<String, String> getVariables() {
    return variables;
  }

  public void setVariables(Map<String, String> variables) {
    this.variables = variables;
  }
}
