package io.sendon.kakao.request;

import java.util.ArrayList;
import java.util.List;

public class Template {

  public String templateName;
  public String templateContent;
  public TemplateMessageType templateMessageType;
  public TemplateEmphasizeType templateEmphasizeType;
  public String templateExtra;
  public String templateAd;
  public String templateTitle;
  public String templateSubtitle;
  public boolean securityFlag;
  public String templateImageName;
  public String templateImageUrl;
  public List<Button> buttons;

  public Template() {
    this.templateName = "";
    this.templateContent = "";
    this.templateExtra = "";
    this.templateAd = "";
    this.templateTitle = "";
    this.templateSubtitle = "";
    this.securityFlag = false;
    this.templateImageName = "";
    this.templateImageUrl = "";
    this.buttons = new ArrayList<>();
  }

  public Template setTemplateName(String templateName) {
    this.templateName = templateName;
    return this;
  }

  public Template setTemplateContent(String templateContent) {
    this.templateContent = templateContent;
    return this;
  }

  public Template setTemplateMessageType(TemplateMessageType templateMessageType) {
    this.templateMessageType = templateMessageType;
    return this;
  }

  public Template setTemplateEmphasizeType(TemplateEmphasizeType templateEmphasizeType) {
    this.templateEmphasizeType = templateEmphasizeType;
    return this;
  }

  public Template setTemplateExtra(String templateExtra) {
    this.templateExtra = templateExtra;
    return this;
  }

  public Template setTemplateAd(String templateAd) {
    this.templateAd = templateAd;
    return this;
  }

  public Template setTemplateTitle(String templateTitle) {
    this.templateTitle = templateTitle;
    return this;
  }

  public Template setTemplateSubtitle(String templateSubtitle) {
    this.templateSubtitle = templateSubtitle;
    return this;
  }

  public Template setSecurityFlag(boolean securityFlag) {
    this.securityFlag = securityFlag;
    return this;
  }

  public Template setTemplateImageName(String templateImageName) {
    this.templateImageName = templateImageName;
    return this;
  }

  public Template setTemplateImageUrl(String templateImageUrl) {
    this.templateImageUrl = templateImageUrl;
    return this;
  }

  public Template addButton(Button button) {
    this.buttons.add(button);
    return this;
  }
}