package io.sendon.kakao.request;

import java.util.List;

public class AlimtalkBuilder {
  public String profileId;
  public String templateId;
  public List<?> to;
  public Reservation reservation;
  public Fallback fallback;

  public AlimtalkBuilder() {

  }

  public AlimtalkBuilder(String profileId, String templateId, List<String> to, Reservation reservation, Fallback fallback) {
    this.profileId = profileId;
    this.templateId = templateId;
    this.to = to;
    this.reservation = reservation;
    this.fallback = fallback;
  }

  public AlimtalkBuilder setProfileId(String profileId) {
    this.profileId = profileId;
    return this;
  }

  public AlimtalkBuilder setTemplateId(String templateId) {
    this.templateId = templateId;
    return this;
  }

  public AlimtalkBuilder setTo(List<?> to) {
    this.to = to;
    return this;
  }

  public AlimtalkBuilder setReservation(Reservation reservation) {
    this.reservation = reservation;
    return this;
  }

  public AlimtalkBuilder setFallback(Fallback fallback) {
    this.fallback = fallback;
    return this;
  }
}
