package io.sendon.kakao.brandmessage.response;

import java.util.ArrayList;
import java.util.List;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;

/**
 * 브랜드메시지 템플릿 목록 응답입니다.
 */
public class BrandMessageTemplateListResponse extends SendonResponse {
  public List<BrandMessageTemplateDetailResponse.TemplateDetail> list = new ArrayList<>();
  public int totalCount;

  public BrandMessageTemplateListResponse(SendonJsonResponse response) {
    super(response);

    if (this.code != 200) return;

    JsonArray dataList = response.dataJson != null && response.dataJson.has("list")
        ? response.dataJson.getAsJsonArray("list")
        : new JsonArray();

    for (int i = 0; i < dataList.size(); i++) {
      JsonObject item = dataList.get(i).getAsJsonObject();
      this.list.add(new BrandMessageTemplateDetailResponse.TemplateDetail(item));
    }

    this.totalCount = response.dataJson != null && response.dataJson.has("totalCount")
        ? response.dataJson.get("totalCount").getAsInt()
        : 0;
  }
}
