package io.sendon.kakao.brandmessage.response;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;

/**
 * 브랜드메시지 템플릿 생성/수정 시 반환되는 식별자 정보입니다.
 */
public class BrandMessageTemplateIdResponse extends SendonResponse {
  public String templateId;
  public String templateCode;

  public BrandMessageTemplateIdResponse(SendonJsonResponse response) {
    super(response);

    if (this.code != 200) return;

    this.templateId = getStringValue(response.dataJson, "templateId");
    this.templateCode = getStringValue(response.dataJson, "templateCode");
  }
}
