package io.sendon.kakao.brandmessage.response;

import java.util.Optional;

import com.google.gson.JsonObject;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;

/**
 * 브랜드메시지 템플릿 상세 응답입니다.
 */
public class BrandMessageTemplateDetailResponse extends SendonResponse {
  public TemplateDetail data;

  public static class TemplateDetail {
    public String templateId;
    public String templateCode;
    public String templateName;
    public String messageType;
    public String status;
    public RejectionReason rejectionReason;
    public JsonObject fallback;
    public String createdAt;
    public String updatedAt;
    public String approvedAt;
    public JsonObject raw;

    TemplateDetail(JsonObject dataJson) {
      this.raw = dataJson.deepCopy();
      this.templateId = dataJson != null ? optionalString(dataJson, "templateId") : "";
      this.templateCode = dataJson != null ? optionalString(dataJson, "templateCode") : "";
      this.templateName = dataJson != null ? optionalString(dataJson, "templateName") : "";
      this.messageType = dataJson != null ? optionalString(dataJson, "messageType") : "";
      this.status = dataJson != null ? optionalString(dataJson, "status") : "";

      JsonObject rejection = dataJson != null && dataJson.has("rejectionReason") && dataJson.get("rejectionReason").isJsonObject()
          ? dataJson.getAsJsonObject("rejectionReason")
          : null;
      this.rejectionReason = rejection != null ? new RejectionReason(rejection) : null;

      this.fallback = dataJson != null && dataJson.has("fallback") && dataJson.get("fallback").isJsonObject()
          ? dataJson.getAsJsonObject("fallback").deepCopy()
          : null;

      this.createdAt = dataJson != null ? optionalString(dataJson, "createdAt") : null;
      this.updatedAt = dataJson != null ? optionalString(dataJson, "updatedAt") : null;
      this.approvedAt = dataJson != null ? optionalString(dataJson, "approvedAt") : null;
    }

    private static String optionalString(JsonObject json, String key) {
      return Optional.ofNullable(json)
          .filter(obj -> obj.has(key) && !obj.get(key).isJsonNull())
          .map(obj -> obj.get(key).getAsString())
          .orElse("");
    }
  }

  public static class RejectionReason {
    public String code;
    public String message;
    public String suggestion;

    RejectionReason(JsonObject json) {
      this.code = json.has("code") && !json.get("code").isJsonNull() ? json.get("code").getAsString() : "";
      this.message = json.has("message") && !json.get("message").isJsonNull() ? json.get("message").getAsString() : "";
      this.suggestion = json.has("suggestion") && !json.get("suggestion").isJsonNull()
          ? json.get("suggestion").getAsString()
          : "";
    }
  }

  public BrandMessageTemplateDetailResponse(SendonJsonResponse response) {
    super(response);

    if (this.code != 200) return;

    this.data = new TemplateDetail(response.dataJson);
  }
}
