package io.sendon.kakao.brandmessage.request;

import com.google.gson.JsonObject;

/**
 * 와이드형 브랜드메시지 템플릿 요청입니다.
 */
public class BrandMessageWideTemplateRequest extends BrandMessageTemplateRequest {
  private String content;
  private String imageUrl;
  private String imageName;
  private String imageLink;

  public BrandMessageWideTemplateRequest setContent(String content) {
    this.content = content;
    return this;
  }

  public BrandMessageWideTemplateRequest setImageUrl(String imageUrl) {
    this.imageUrl = imageUrl;
    return this;
  }

  public BrandMessageWideTemplateRequest setImageName(String imageName) {
    this.imageName = imageName;
    return this;
  }

  public BrandMessageWideTemplateRequest setImageLink(String imageLink) {
    this.imageLink = imageLink;
    return this;
  }

  @Override
  public JsonObject toJson() {
    JsonObject json = new JsonObject();
    writeCommon(json);
    json.addProperty("content", this.content);
    json.addProperty("imageUrl", this.imageUrl);
    if (this.imageName != null) json.addProperty("imageName", this.imageName);
    if (this.imageLink != null) json.addProperty("imageLink", this.imageLink);
    return json;
  }
}
