package io.sendon.kakao.brandmessage.request;

import java.util.ArrayList;
import java.util.List;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

/**
 * 와이드 아이템리스트형 브랜드메시지 템플릿 요청입니다.
 */
public class BrandMessageWideItemListTemplateRequest extends BrandMessageTemplateRequest {
  public static class MainWideItem {
    private String title;
    private String imageUrl;
    private String linkM;
    private String linkP;
    private String linkI;
    private String linkA;

    public MainWideItem setTitle(String title) {
      this.title = title;
      return this;
    }

    public MainWideItem setImageUrl(String imageUrl) {
      this.imageUrl = imageUrl;
      return this;
    }

    public MainWideItem setLinkM(String linkM) {
      this.linkM = linkM;
      return this;
    }

    public MainWideItem setLinkP(String linkP) {
      this.linkP = linkP;
      return this;
    }

    public MainWideItem setLinkI(String linkI) {
      this.linkI = linkI;
      return this;
    }

    public MainWideItem setLinkA(String linkA) {
      this.linkA = linkA;
      return this;
    }

    public JsonObject toJson() {
      JsonObject json = new JsonObject();
      if (this.title != null) json.addProperty("title", this.title);
      json.addProperty("imageUrl", this.imageUrl);
      json.addProperty("linkM", this.linkM);
      if (this.linkP != null) json.addProperty("linkP", this.linkP);
      if (this.linkI != null) json.addProperty("linkI", this.linkI);
      if (this.linkA != null) json.addProperty("linkA", this.linkA);
      return json;
    }
  }

  public static class SubWideItem {
    private String title;
    private String imageUrl;
    private String linkM;
    private String linkP;
    private String linkI;
    private String linkA;

    public SubWideItem setTitle(String title) {
      this.title = title;
      return this;
    }

    public SubWideItem setImageUrl(String imageUrl) {
      this.imageUrl = imageUrl;
      return this;
    }

    public SubWideItem setLinkM(String linkM) {
      this.linkM = linkM;
      return this;
    }

    public SubWideItem setLinkP(String linkP) {
      this.linkP = linkP;
      return this;
    }

    public SubWideItem setLinkI(String linkI) {
      this.linkI = linkI;
      return this;
    }

    public SubWideItem setLinkA(String linkA) {
      this.linkA = linkA;
      return this;
    }

    public JsonObject toJson() {
      JsonObject json = new JsonObject();
      json.addProperty("title", this.title);
      json.addProperty("imageUrl", this.imageUrl);
      json.addProperty("linkM", this.linkM);
      if (this.linkP != null) json.addProperty("linkP", this.linkP);
      if (this.linkI != null) json.addProperty("linkI", this.linkI);
      if (this.linkA != null) json.addProperty("linkA", this.linkA);
      return json;
    }
  }

  private String header;
  private MainWideItem mainWideItem;
  private final List<SubWideItem> subWideItemList = new ArrayList<>();

  public BrandMessageWideItemListTemplateRequest setHeader(String header) {
    this.header = header;
    return this;
  }

  public BrandMessageWideItemListTemplateRequest setMainWideItem(MainWideItem mainWideItem) {
    this.mainWideItem = mainWideItem;
    return this;
  }

  public BrandMessageWideItemListTemplateRequest addSubWideItem(SubWideItem subItem) {
    if (subItem != null) this.subWideItemList.add(subItem);
    return this;
  }

  public BrandMessageWideItemListTemplateRequest setSubWideItemList(List<SubWideItem> subItems) {
    this.subWideItemList.clear();
    if (subItems != null) this.subWideItemList.addAll(subItems);
    return this;
  }

  @Override
  public JsonObject toJson() {
    JsonObject json = new JsonObject();
    writeCommon(json);
    json.addProperty("header", this.header);
    if (this.mainWideItem != null) {
      json.add("mainWideItem", this.mainWideItem.toJson());
    }

    JsonArray subItems = new JsonArray();
    this.subWideItemList.forEach(item -> subItems.add(item.toJson()));
    json.add("subWideItemList", subItems);
    return json;
  }
}
