package io.sendon.kakao.brandmessage.request;

import java.util.ArrayList;
import java.util.List;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

/**
 * 브랜드메시지 템플릿 요청의 공통 속성입니다.
 */
public abstract class BrandMessageTemplateRequest {
  protected String templateName;
  protected final List<BrandMessageButton> buttons = new ArrayList<>();
  protected BrandMessageCoupon coupon;
  protected BrandMessageFallback fallback;

  public BrandMessageTemplateRequest setTemplateName(String templateName) {
    this.templateName = templateName;
    return this;
  }

  public BrandMessageTemplateRequest addButton(BrandMessageButton button) {
    if (button != null) this.buttons.add(button);
    return this;
  }

  public BrandMessageTemplateRequest setButtons(List<BrandMessageButton> buttons) {
    this.buttons.clear();
    if (buttons != null) this.buttons.addAll(buttons);
    return this;
  }

  public BrandMessageTemplateRequest setCoupon(BrandMessageCoupon coupon) {
    this.coupon = coupon;
    return this;
  }

  public BrandMessageTemplateRequest setFallback(BrandMessageFallback fallback) {
    this.fallback = fallback;
    return this;
  }

  protected void writeCommon(JsonObject json) {
    json.addProperty("templateName", this.templateName);
    if (!this.buttons.isEmpty()) {
      JsonArray array = new JsonArray();
      this.buttons.forEach(button -> array.add(button.toJson()));
      json.add("buttons", array);
    }
    if (this.coupon != null) {
      json.add("coupon", this.coupon.toJson());
    }
    if (this.fallback != null) {
      json.add("fallback", this.fallback.toJson());
    }
  }

  public abstract JsonObject toJson();
}
