package io.sendon.kakao.brandmessage.request;

import java.util.List;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

import io.sendon.kakao.request.Fallback;
import io.sendon.kakao.request.Reservation;

/**
 * 브랜드메시지 발송 요청을 구성하는 빌더입니다.
 */
public class BrandMessageSendBuilder {
  private String sendProfileId;
  private String templateCode;
  private List<?> to;
  private String targeting;
  private Reservation reservation;
  private Fallback fallback;
  private Boolean useCredit;

  public BrandMessageSendBuilder setSendProfileId(String sendProfileId) {
    this.sendProfileId = sendProfileId;
    return this;
  }

  public BrandMessageSendBuilder setTemplateCode(String templateCode) {
    this.templateCode = templateCode;
    return this;
  }

  public BrandMessageSendBuilder setTo(List<?> to) {
    this.to = to;
    return this;
  }

  public BrandMessageSendBuilder setTargeting(String targeting) {
    this.targeting = targeting;
    return this;
  }

  public BrandMessageSendBuilder setReservation(Reservation reservation) {
    this.reservation = reservation;
    return this;
  }

  public BrandMessageSendBuilder setFallback(Fallback fallback) {
    this.fallback = fallback;
    return this;
  }

  public BrandMessageSendBuilder setUseCredit(Boolean useCredit) {
    this.useCredit = useCredit;
    return this;
  }

  public JsonObject toJson() {
    JsonObject bodyJson = new JsonObject();
    bodyJson.addProperty("sendProfileId", this.sendProfileId);
    bodyJson.addProperty("templateCode", this.templateCode);

    if (this.targeting != null) {
      bodyJson.addProperty("targeting", this.targeting);
    }

    if (this.useCredit != null) {
      bodyJson.addProperty("useCredit", this.useCredit);
    }

    if (this.to != null) {
      JsonArray toArray = new JsonArray();
      for (Object item : this.to) {
        if (item instanceof String) {
          toArray.add((String) item);
        } else if (item instanceof io.sendon.kakao.request.ToWithVariable) {
          io.sendon.kakao.request.ToWithVariable toWithVariable = (io.sendon.kakao.request.ToWithVariable) item;
          JsonObject toObject = new JsonObject();
          toObject.addProperty("phone", toWithVariable.getPhone());
          JsonObject variablesJson = new JsonObject();
          if (toWithVariable.getVariables() != null) {
            toWithVariable
                .getVariables()
                .forEach(variablesJson::addProperty);
          }
          toObject.add("variables", variablesJson);
          toArray.add(toObject);
        }
      }
      bodyJson.add("to", toArray);
    }

    if (this.reservation != null) {
      JsonObject reservationJson = new JsonObject();
      reservationJson.addProperty("datetime", this.reservation.datetime);
      bodyJson.add("reservation", reservationJson);
    }

    if (this.fallback != null) {
      JsonObject fallbackJson = new JsonObject();
      fallbackJson.addProperty("fallbackType", this.fallback.fallbackType.value);

      if (this.fallback.fallbackType == Fallback.FallbackType.CUSTOM && this.fallback.custom != null) {
        JsonObject customJson = new JsonObject();
        customJson.addProperty("type", this.fallback.custom.type.name());
        customJson.addProperty("senderNumber", this.fallback.custom.senderNumber);
        customJson.addProperty("isAd", this.fallback.custom.isAd);
        customJson.addProperty("message", this.fallback.custom.message);
        customJson.addProperty("title", this.fallback.custom.title);

        if (this.fallback.custom.images != null && !this.fallback.custom.images.isEmpty()) {
          JsonArray imagesArray = new JsonArray();
          this.fallback.custom.images.forEach(imagesArray::add);
          customJson.add("images", imagesArray);
        }

        fallbackJson.add("custom", customJson);
      }

      bodyJson.add("fallback", fallbackJson);
    }

    return bodyJson;
  }
}
