package io.sendon.kakao.brandmessage.request;

import com.google.gson.JsonObject;

/**
 * 이미지형 브랜드메시지 템플릿 요청입니다.
 */
public class BrandMessageImageTemplateRequest extends BrandMessageTemplateRequest {
  private String content;
  private String imageUrl;
  private String imageName;
  private String imageLink;

  public BrandMessageImageTemplateRequest setContent(String content) {
    this.content = content;
    return this;
  }

  public BrandMessageImageTemplateRequest setImageUrl(String imageUrl) {
    this.imageUrl = imageUrl;
    return this;
  }

  public BrandMessageImageTemplateRequest setImageName(String imageName) {
    this.imageName = imageName;
    return this;
  }

  public BrandMessageImageTemplateRequest setImageLink(String imageLink) {
    this.imageLink = imageLink;
    return this;
  }

  @Override
  public JsonObject toJson() {
    JsonObject json = new JsonObject();
    writeCommon(json);
    json.addProperty("content", this.content);
    json.addProperty("imageUrl", this.imageUrl);
    if (this.imageName != null) json.addProperty("imageName", this.imageName);
    if (this.imageLink != null) json.addProperty("imageLink", this.imageLink);
    return json;
  }
}
