package io.sendon.kakao.brandmessage.request;

import java.util.ArrayList;
import java.util.List;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

/**
 * 브랜드메시지 대체문자 설정입니다.
 */
public class BrandMessageFallback {
  public enum MessageType {
    SMS("SMS"),
    LMS("LMS"),
    MMS("MMS");

    public final String value;

    MessageType(String value) {
      this.value = value;
    }
  }

  private String senderNumber;
  private MessageType type;
  private String message;
  private String title;
  private final List<String> images = new ArrayList<>();
  private Boolean isAd;
  private String groupId;

  public BrandMessageFallback setSenderNumber(String senderNumber) {
    this.senderNumber = senderNumber;
    return this;
  }

  public BrandMessageFallback setType(MessageType type) {
    this.type = type;
    return this;
  }

  public BrandMessageFallback setMessage(String message) {
    this.message = message;
    return this;
  }

  public BrandMessageFallback setTitle(String title) {
    this.title = title;
    return this;
  }

  public BrandMessageFallback addImage(String imageUrl) {
    if (imageUrl != null) this.images.add(imageUrl);
    return this;
  }

  public BrandMessageFallback setImages(List<String> imageUrls) {
    this.images.clear();
    if (imageUrls != null) this.images.addAll(imageUrls);
    return this;
  }

  public BrandMessageFallback setIsAd(Boolean isAd) {
    this.isAd = isAd;
    return this;
  }

  public BrandMessageFallback setGroupId(String groupId) {
    this.groupId = groupId;
    return this;
  }

  public JsonObject toJson() {
    JsonObject json = new JsonObject();
    json.addProperty("senderNumber", this.senderNumber);
    json.addProperty("type", this.type != null ? this.type.value : null);
    json.addProperty("message", this.message);
    if (this.title != null) json.addProperty("title", this.title);
    if (!this.images.isEmpty()) {
      JsonArray imagesArray = new JsonArray();
      this.images.forEach(imagesArray::add);
      json.add("images", imagesArray);
    }
    if (this.isAd != null) json.addProperty("isAd", this.isAd);
    if (this.groupId != null) json.addProperty("groupId", this.groupId);
    return json;
  }
}
