package io.sendon.kakao.brandmessage.request;

import com.google.gson.JsonObject;

/**
 * 브랜드메시지 쿠폰 정보입니다.
 */
public class BrandMessageCoupon {
  private String title;
  private String description;
  private String linkM;
  private String linkP;
  private String linkI;
  private String linkA;

  public BrandMessageCoupon setTitle(String title) {
    this.title = title;
    return this;
  }

  public BrandMessageCoupon setDescription(String description) {
    this.description = description;
    return this;
  }

  public BrandMessageCoupon setLinkM(String linkM) {
    this.linkM = linkM;
    return this;
  }

  public BrandMessageCoupon setLinkP(String linkP) {
    this.linkP = linkP;
    return this;
  }

  public BrandMessageCoupon setLinkI(String linkI) {
    this.linkI = linkI;
    return this;
  }

  public BrandMessageCoupon setLinkA(String linkA) {
    this.linkA = linkA;
    return this;
  }

  public JsonObject toJson() {
    JsonObject json = new JsonObject();
    json.addProperty("title", this.title);
    if (this.description != null) json.addProperty("description", this.description);
    if (this.linkM != null) json.addProperty("linkM", this.linkM);
    if (this.linkP != null) json.addProperty("linkP", this.linkP);
    if (this.linkI != null) json.addProperty("linkI", this.linkI);
    if (this.linkA != null) json.addProperty("linkA", this.linkA);
    return json;
  }
}
