package io.sendon.kakao.brandmessage.request;

import java.util.ArrayList;
import java.util.List;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

/**
 * 캐러셀 피드형 브랜드메시지 템플릿 요청입니다.
 */
public class BrandMessageCarouselFeedTemplateRequest extends BrandMessageTemplateRequest {
  public static class CarouselCard {
    private String header;
    private String content;
    private String imageUrl;
    private String imageLink;
    private final List<BrandMessageButton> buttons = new ArrayList<>();
    private BrandMessageCoupon coupon;

    public CarouselCard setHeader(String header) {
      this.header = header;
      return this;
    }

    public CarouselCard setContent(String content) {
      this.content = content;
      return this;
    }

    public CarouselCard setImageUrl(String imageUrl) {
      this.imageUrl = imageUrl;
      return this;
    }

    public CarouselCard setImageLink(String imageLink) {
      this.imageLink = imageLink;
      return this;
    }

    public CarouselCard addButton(BrandMessageButton button) {
      if (button != null) this.buttons.add(button);
      return this;
    }

    public CarouselCard setButtons(List<BrandMessageButton> buttons) {
      this.buttons.clear();
      if (buttons != null) this.buttons.addAll(buttons);
      return this;
    }

    public CarouselCard setCoupon(BrandMessageCoupon coupon) {
      this.coupon = coupon;
      return this;
    }

    public JsonObject toJson() {
      JsonObject json = new JsonObject();
      json.addProperty("header", this.header);
      json.addProperty("content", this.content);
      json.addProperty("imageUrl", this.imageUrl);
      if (this.imageLink != null) json.addProperty("imageLink", this.imageLink);
      if (!this.buttons.isEmpty()) {
        JsonArray array = new JsonArray();
        this.buttons.forEach(button -> array.add(button.toJson()));
        json.add("buttons", array);
      }
      if (this.coupon != null) {
        json.add("coupon", this.coupon.toJson());
      }
      return json;
    }
  }

  public static class CarouselTail {
    private String linkM;
    private String linkP;
    private String linkI;
    private String linkA;

    public CarouselTail setLinkM(String linkM) {
      this.linkM = linkM;
      return this;
    }

    public CarouselTail setLinkP(String linkP) {
      this.linkP = linkP;
      return this;
    }

    public CarouselTail setLinkI(String linkI) {
      this.linkI = linkI;
      return this;
    }

    public CarouselTail setLinkA(String linkA) {
      this.linkA = linkA;
      return this;
    }

    public JsonObject toJson() {
      JsonObject json = new JsonObject();
      json.addProperty("linkM", this.linkM);
      if (this.linkP != null) json.addProperty("linkP", this.linkP);
      if (this.linkI != null) json.addProperty("linkI", this.linkI);
      if (this.linkA != null) json.addProperty("linkA", this.linkA);
      return json;
    }
  }

  private final List<CarouselCard> list = new ArrayList<>();
  private CarouselTail tail;

  public BrandMessageCarouselFeedTemplateRequest addCard(CarouselCard card) {
    if (card != null) this.list.add(card);
    return this;
  }

  public BrandMessageCarouselFeedTemplateRequest setCards(List<CarouselCard> cards) {
    this.list.clear();
    if (cards != null) this.list.addAll(cards);
    return this;
  }

  public BrandMessageCarouselFeedTemplateRequest setTail(CarouselTail tail) {
    this.tail = tail;
    return this;
  }

  @Override
  public JsonObject toJson() {
    JsonObject json = new JsonObject();
    writeCommon(json);

    JsonObject carousel = new JsonObject();
    JsonArray cardArray = new JsonArray();
    this.list.forEach(card -> cardArray.add(card.toJson()));
    carousel.add("list", cardArray);
    if (this.tail != null) {
      carousel.add("tail", this.tail.toJson());
    }

    json.add("carousel", carousel);
    return json;
  }
}
