package io.sendon.kakao.brandmessage.request;

import com.google.gson.JsonObject;

/**
 * 브랜드메시지 버튼 정보입니다.
 */
public class BrandMessageButton {
  private String name;
  private BrandMessageLinkType linkType;
  private String linkM;
  private String linkP;
  private String linkI;
  private String linkA;

  public BrandMessageButton setName(String name) {
    this.name = name;
    return this;
  }

  public BrandMessageButton setLinkType(BrandMessageLinkType linkType) {
    this.linkType = linkType;
    return this;
  }

  public BrandMessageButton setLinkM(String linkM) {
    this.linkM = linkM;
    return this;
  }

  public BrandMessageButton setLinkP(String linkP) {
    this.linkP = linkP;
    return this;
  }

  public BrandMessageButton setLinkI(String linkI) {
    this.linkI = linkI;
    return this;
  }

  public BrandMessageButton setLinkA(String linkA) {
    this.linkA = linkA;
    return this;
  }

  public JsonObject toJson() {
    JsonObject json = new JsonObject();
    json.addProperty("name", this.name);
    json.addProperty("linkType", this.linkType != null ? this.linkType.value : null);
    if (this.linkM != null) json.addProperty("linkM", this.linkM);
    if (this.linkP != null) json.addProperty("linkP", this.linkP);
    if (this.linkI != null) json.addProperty("linkI", this.linkI);
    if (this.linkA != null) json.addProperty("linkA", this.linkA);
    return json;
  }
}
