package io.sendon.contacts.response;

import java.lang.reflect.Type;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import io.sendon.base.SendonJsonResponse;
import io.sendon.base.SendonResponse;

public class GetBlocklist extends SendonResponse {
  public GetBlocklistData data;

  public static class BlocklistItem {
    public long userId;
    public long channelId;
    public String phoneNumber;
    public String senderNumber;
    public long blockId;
    public String blockType;
    public String blockDomain;
    public String messageType;
    public String kakaoChannelId;
    public String rcsBrandId;
    public String rcsChatbotId;
    public String createdAt;
  }

  public static class GetBlocklistData {
    public Long cursor;
    public long totalCount;
    public List<BlocklistItem> blocklist;
  }

  public GetBlocklist(SendonJsonResponse sendonJsonResponse) {
    super(sendonJsonResponse);

    if (this.code != 200) return;

    Type type = new TypeToken<GetBlocklistData>(){}.getType();
    this.data = new Gson().fromJson(sendonJsonResponse.dataJson, type);
  }
}
