package io.sendon.contacts.request;

/**
 * Request object for retrieving blocklist entries with filtering and pagination.
 * Represents the query parameters for blocklist retrieval API.
 */
public class GetBlocklistRequest {
  
  /**
   * Filter by specific sender number.
   * If not provided, retrieves blocklist for all sender numbers.
   */
  public String senderNumber;
  
  /**
   * Array of Kakao channel IDs to filter by.
   * Only applicable for Kakao message blocklist.
   */
  public String[] kakaoChannelIds;
  
  /**
   * Array of block types to filter by.
   * Valid values: WEB, API, ARS
   */
  public String[] blockTypes;
  
  /**
   * Start date for filtering in YYYY-MM-DD HH:mm:ss format.
   * Filters blocklist entries created on or after this date.
   */
  public String startDate;
  
  /**
   * End date for filtering in YYYY-MM-DD HH:mm:ss format.
   * Filters blocklist entries created on or before this date.
   */
  public String endDate;
  
  /**
   * Cursor for pagination.
   * Use the cursor from previous response to get next page.
   * Default is 0 for first page.
   */
  public Integer cursor;
  
  /**
   * Maximum number of entries to retrieve per page.
   * Default is 20, should not be set too high to avoid slow response.
   */
  public Integer limit;

  public GetBlocklistRequest() {}

  /**
   * Constructor for simple pagination.
   *
   * @param cursor The cursor for pagination
   * @param limit The maximum number of entries to retrieve
   */
  public GetBlocklistRequest(Integer cursor, Integer limit) {
    this.cursor = cursor;
    this.limit = limit;
  }

  /**
   * Constructor with all parameters.
   *
   * @param senderNumber Filter by specific sender number
   * @param kakaoChannelIds Array of Kakao channel IDs to filter by
   * @param blockTypes Array of block types to filter by
   * @param startDate Start date for filtering
   * @param endDate End date for filtering
   * @param cursor Cursor for pagination
   * @param limit Maximum number of entries to retrieve
   */
  public GetBlocklistRequest(String senderNumber, String[] kakaoChannelIds, String[] blockTypes,
                           String startDate, String endDate, Integer cursor, Integer limit) {
    this.senderNumber = senderNumber;
    this.kakaoChannelIds = kakaoChannelIds;
    this.blockTypes = blockTypes;
    this.startDate = startDate;
    this.endDate = endDate;
    this.cursor = cursor;
    this.limit = limit;
  }
}