package io.sendon.contacts.request;

/**
 * Request object for creating a blocklist entry.
 * Represents the request payload for adding a phone number to the blocklist.
 */
public class CreateBlocklistRequest {
  
  /**
   * The phone number to be added to the blocklist.
   * Should be provided without hyphens, numbers only.
   */
  public String phoneNumber;
  
  /**
   * The message type for blocking (SMS, KAKAO, RCS).
   * Default is SMS if not specified.
   */
  public String messageType;
  
  /**
   * The sender number to block from.
   * Optional parameter for specific sender blocking.
   */
  public String senderNumber;
  
  /**
   * The Kakao channel ID for Kakao message blocking.
   * Required when messageType is KAKAO.
   */
  public String kakaoChannelId;
  
  /**
   * The RCS chatbot ID for RCS message blocking.
   * Required when messageType is RCS.
   */
  public String rcsChatbotId;
  
  /**
   * The RCS brand ID for RCS message blocking.
   * Required when messageType is RCS.
   */
  public String rcsBrandId;

  public CreateBlocklistRequest() {}

  /**
   * Constructor for simple SMS blocking.
   *
   * @param phoneNumber The phone number to block
   */
  public CreateBlocklistRequest(String phoneNumber) {
    this.phoneNumber = phoneNumber;
    this.messageType = "SMS";
  }

  /**
   * Constructor with all parameters.
   *
   * @param phoneNumber The phone number to block
   * @param messageType The message type (SMS, KAKAO, RCS)
   * @param senderNumber The sender number to block from
   * @param kakaoChannelId The Kakao channel ID
   * @param rcsChatbotId The RCS chatbot ID
   * @param rcsBrandId The RCS brand ID
   */
  public CreateBlocklistRequest(String phoneNumber, String messageType, String senderNumber,
                              String kakaoChannelId, String rcsChatbotId, String rcsBrandId) {
    this.phoneNumber = phoneNumber;
    this.messageType = messageType;
    this.senderNumber = senderNumber;
    this.kakaoChannelId = kakaoChannelId;
    this.rcsChatbotId = rcsChatbotId;
    this.rcsBrandId = rcsBrandId;
  }
}