package io.sendon.base;

import java.io.File;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

public class SendonClient {
  protected HttpClient httpClient;
  protected Gson gson = new GsonBuilder().setPrettyPrinting().create();

  public SendonClient(String userId, String apiKey) {
    String baseUrl = System.getProperty("base.url", "https://api.sendon.io");
    this.httpClient = new SquareupOkHttpClient(baseUrl, userId, apiKey);
  }

  public SendonClient(String userId, String apiKey, boolean useOkHttp) {
    String baseUrl = System.getProperty("base.url", "https://api.sendon.io");
    this.httpClient = useOkHttp ? new SquareupOkHttpClient(baseUrl, userId, apiKey) : new ApacheHttpClient(baseUrl, userId, apiKey);
  }

  public SendonClient(String baseUrl, String userId, String apiKey, boolean useOkHttp) {
    this.httpClient = useOkHttp ? new SquareupOkHttpClient(baseUrl, userId, apiKey) : new ApacheHttpClient(baseUrl, userId, apiKey);
  }

  public String get(String path) {
    return httpClient.get(path);
  }

  public String post(String path, String body) {
    return httpClient.post(path, body);
  }

  public String put(String path, String body) {
    return httpClient.put(path, body);
  }

  public String delete(String path) {
    return httpClient.delete(path);
  }

  public String postImageWithMultipartFormData(String path, File image) {
    return httpClient.postImageWithMulStringFormData(path, image);
  }

  public String postImageWithMultipartFormData(String path, File image, String fieldName, String contentType) {
    return httpClient.postImageWithMulStringFormData(path, image, fieldName, contentType);
  }

  public String postImagesWithMultipartFormData(String path, List<File> images) {
    return httpClient.postImagesWithMultipartFormData(path, images);
  }

  public SendonJsonResponse parseJsonResponse(String jsonResponse) {
    // Log.d("JsonResponse: " + gson.toJson(jsonResponse));
    JsonObject jsonObject = JsonParser.parseString(jsonResponse).getAsJsonObject();
    int code = jsonObject.get("code").getAsInt();
    String message = jsonObject.get("message").getAsString();
    JsonObject data = null;
    if(jsonObject.get("data") != null) {
      data = jsonObject.get("data").getAsJsonObject();
    }
    SendonJsonResponse sendonJsonResponse = new SendonJsonResponse(code, message, data);
    // Log.d("SendonJsonResponse: " + gson.toJson(sendonJsonResponse));
    return sendonJsonResponse;
  }
}
