define(function(require){

	var ko = require("knockout"),
		hasher = require("hasher"),
		crossroads = require("crossroads"),
		router = crossroads.create();
	
	router.normalizeFn = crossroads.NORM_AS_OBJECT;
	router.ignoreState = true;
	
	function parseHash(newHash, oldHash){ router.parse(newHash); };

	hasher.initialized.add(parseHash);
	hasher.changed.add(parseHash);
	
	hasher.init();

	ko.bindingHandlers.route = {
		init: function(element, valueAccessor, allBindings, viewModel, bindingContext){
			var opts = valueAccessor(),
				eager = false,
				route;

			if (typeof(opts) === "string"){
				//Single string argument
				route = opts;
			} else if (typeof(opts) === "object"){
				//Extended arguments
				// { path: '', eager: true }
				route = opts.path;
				eager = opts.eager ? true : false;
			}

			var initialized = false,
				observableParams = {},
				hide = function(){
					element.style.display = "none";
				},
				show = function(){
					element.style.display = "block";
				},
				initialize = function(){
					var innerBindingContext = bindingContext.extend(observableParams);					
					ko.applyBindingsToDescendants(innerBindingContext, element);
					
					initialized = true;
				};
				
			//TODO: scrolling http://stackoverflow.com/questions/1925671/javascript-window-scroll-vs-window-scrollto
			
			//console.log("INIT Route: ", route);
			
			var routeInstance = router.addRoute(route, function(params){				

				Object.keys(params).forEach(function(key){
					if (ko.isObservable(observableParams[key]))
						//Apply new param to params
						observableParams[key](params[key]);
					else if (typeof(observableParams[key]) == "undefined")
						//No such attribute, create
						observableParams[key] = ko.observable(params[key]);
				});
			
				if (!initialized)
					//Create initial instance
					initialize();
				
				//make visible
				show();
			});

			if (eager)
				initialize();
			
			
			routeInstance.switched.add(function(){
				//Leave
				hide();
			});
			
			ko.utils.domNodeDisposal.addDisposeCallback(element, function(){
				//console.log("DISPOSE Route: ", route);				
				routeInstance.dispose();
			});

			//Hide element by default
			hide();
			
			//re-route on new routes
			setTimeout(function(){
				router.parse( hasher.getHash() );
			}, 50);
		
			return { controlsDescendantBindings: true };
		},
		update: function(element, valueAccessor, allBindings, viewModel, bindingContext){
		}
	};
	
	return {
		router: router,
		hasher: hasher
	};


});
