define(function(require){

	var ko = require("knockout"),
		$ = require("jquery");

	return function(){
		var self = this;
		
		this.result = ko.observable();
		this.error = ko.observable();

		this.username = ko.observable("");
		this.password = ko.observable("");
		
		this.login = function(){
			
			self.error(undefined);
			self.result(undefined);
			
			$.ajax({
				url: 'api/token/create',
				type: 'POST',
				data: {
					username: self.username(),
					password: self.password()
				}
			})
			.then(function(token){
				
				self.result(token);
				
				$.ajaxSetup({
					headers: {
						"Authorization": token
					}
				});
				
			})
			.fail(function(jqXhr, msg, title){
				self.error(jqXhr.responseText);
			});

			
		};
		
		this.claims = ko.computed(function(){
			
			if (self.result())
				return atob(self.result().split(".")[1]);
			
		});
		
		this.tokenSize = ko.computed(function(){
			if (self.result())
				return self.result().length + " bytes";
		});
		
	};
	

});
