package io.rudin.cdi.webtoken.app;

import io.rudin.cdi.webtoken.Constants;
import io.rudin.cdi.webtoken.service.CurrentTokenService;
import io.rudin.cdi.webtoken.service.WebTokenService;

import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;

@RequestScoped
@Path("token")
public class TokenApi
{
	
	@Inject WebTokenService webtokenService;
	
	@Context HttpServletRequest request;
	@Context HttpServletResponse response;
	
	@POST
	@Path("create")
	@Produces(MediaType.TEXT_PLAIN)
	public String createToken(@FormParam("username") String username, @FormParam("password") String password)
	{
		
		if ("test".equals(username) && "test".equals(password))
		{
			String token = webtokenService.sign("test");
			
			Cookie cookie = new Cookie(Constants.HEADER_KEY, token);
			cookie.setPath("/");
			cookie.setHttpOnly(true);
			response.addCookie(cookie);
			
			return token;
		}

		
		//No such username
		return null;
	}
	
	@Inject CurrentTokenService currentToken;
	
	@GET
	@Path("validate")
	@Produces(MediaType.APPLICATION_JSON)
	public Object validate()
	{
		return currentToken.getClaims();
	}

}
