/*
 * Decompiled with CFR 0.152.
 */
package io.rudin.usermanagement.impl;

import io.rudin.cdi.entitymanager.api.entitymanager.EntityManagerCloser;
import io.rudin.cdi.entitymanager.repository.Repository;
import io.rudin.usermanagement.api.cdi.qualifier.UserManagement;
import io.rudin.usermanagement.api.entities.User;
import io.rudin.usermanagement.api.repository.UserRepository;
import io.rudin.usermanagement.impl.UserImpl;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

@Dependent
public class UserRepositoryImpl
extends Repository<UserImpl, Long>
implements UserRepository {
    @Inject
    @UserManagement
    Instance<EntityManager> emInstance;

    protected Instance<EntityManager> getEntityManagerInstance() {
        return this.emInstance;
    }

    public List<User> findByUsername(String username) {
        try (EntityManagerCloser emc = new EntityManagerCloser(this.emInstance);){
            EntityManager em = emc.getEntityManager();
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery query = cb.createQuery(this.getEntityClass());
            Root root = query.from(this.getEntityClass());
            CriteriaQuery select = query.select((Selection)root);
            select.where((Expression)cb.equal((Expression)root.get("username"), (Object)username));
            List list = em.createQuery(query).getResultList();
            ArrayList<User> userList = new ArrayList<User>();
            list.forEach(userList::add);
            ArrayList<User> arrayList = userList;
            return arrayList;
        }
    }

    protected Class<UserImpl> getEntityClass() {
        return UserImpl.class;
    }

    protected String getIDFieldName() {
        return "id";
    }

    public User save(User user) {
        return (User)this.save((UserImpl)user);
    }

    public void remove(User user) {
        this.remove((UserImpl)user);
    }

    public List<User> getAll() {
        ArrayList<User> userList = new ArrayList<User>();
        this.findAll().forEach(userList::add);
        return userList;
    }
}

