/*
 * Decompiled with CFR 0.152.
 */
package io.rudin.cdi.entitymanager.bean;

import io.rudin.cdi.entitymanager.api.PersistenceConfiguration;
import io.rudin.cdi.entitymanager.api.PersistenceConfigurationProperties;
import io.rudin.cdi.entitymanager.config.PersistenceContextConfiguration;
import io.rudin.cdi.entitymanager.store.UnitStore;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.AnnotationLiteral;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagerFactoryBean
implements Bean<EntityManagerFactory> {
    private static final Logger logger = LoggerFactory.getLogger(EntityManagerFactoryBean.class);
    private final BeanManager bm;
    private final PersistenceContextConfiguration config;
    private EntityManagerFactory factory;
    private PersistenceConfiguration configuration;

    public EntityManagerFactoryBean(BeanManager bm, PersistenceContextConfiguration config) {
        this.bm = bm;
        this.config = config;
        logger.debug("Created new factory-bean for qualifiers: {}", config.getQualifiers());
    }

    public synchronized EntityManagerFactory create(CreationalContext<EntityManagerFactory> creationalContext) {
        if (this.factory == null) {
            HashSet<Object> qualifiers = new HashSet<Object>();
            if (this.config.getQualifiers().isEmpty()) {
                qualifiers.add(new AnnotationLiteral<Default>(){});
            } else {
                qualifiers.addAll(this.config.getQualifiers());
            }
            Set beans = this.bm.getBeans(PersistenceConfiguration.class, qualifiers.toArray(new Annotation[qualifiers.size()]));
            this.configuration = (PersistenceConfiguration)this.bm.getReference((Bean)beans.iterator().next(), PersistenceConfiguration.class, creationalContext);
            logger.debug("Got config class: {}", (Object)this.configuration.getClass().getName());
            HashMap<String, String> defaultConfig = new HashMap<String, String>();
            defaultConfig.put("hibernate.connection.provider_class", "org.hibernate.connection.C3P0ConnectionProvider");
            defaultConfig.put("hibernate.c3p0.min_size", "5");
            defaultConfig.put("hibernate.c3p0.max_size", "100");
            defaultConfig.put("hibernate.c3p0.timeout", "100");
            defaultConfig.put("hibernate.c3p0.max_statements", "50");
            defaultConfig.put("hibernate.c3p0.idle_test_period", "1000");
            defaultConfig.put("hibernate.c3p0.validate", "true");
            defaultConfig.put("javax.persistence.jdbc.driver", this.configuration.getDriver());
            defaultConfig.put("javax.persistence.jdbc.url", this.configuration.getUrl());
            defaultConfig.put("javax.persistence.jdbc.user", this.configuration.getUsername());
            defaultConfig.put("javax.persistence.jdbc.password", this.configuration.getPassword());
            HashSet<Object> propertyQualifiers = new HashSet<Object>();
            if (this.config.getQualifiers().isEmpty()) {
                propertyQualifiers.add(new AnnotationLiteral<Any>(){});
            } else {
                propertyQualifiers.addAll(this.config.getQualifiers());
            }
            propertyQualifiers.add(new AnnotationLiteral<PersistenceConfigurationProperties>(){});
            Set propertyBeans = this.bm.getBeans(Object.class, propertyQualifiers.toArray(new Annotation[propertyQualifiers.size()]));
            for (Bean next : propertyBeans) {
                Map map = (Map)this.bm.getReference(next, Object.class, creationalContext);
                logger.debug("Got additional properties: {}", (Object)map);
                defaultConfig.putAll(map);
            }
            logger.info("Creating entitymanager factory for pu: {}", (Object)this.configuration.getUnitName());
            this.factory = Persistence.createEntityManagerFactory((String)this.configuration.getUnitName(), defaultConfig);
        }
        return this.factory;
    }

    public synchronized void destroy(EntityManagerFactory instance, CreationalContext<EntityManagerFactory> creationalContext) {
        if (this.factory != null) {
            logger.info("Shutting down entitymanager factory for pu: {}", (Object)this.configuration.getUnitName());
            UnitStore.clear(this.configuration.getUnitName());
            this.factory.close();
        }
    }

    public Set<Type> getTypes() {
        HashSet<Type> set = new HashSet<Type>();
        set.add((Type)((Object)Object.class));
        set.add((Type)((Object)EntityManagerFactory.class));
        return set;
    }

    public Set<Annotation> getQualifiers() {
        HashSet<Annotation> set = new HashSet<Annotation>();
        if (this.config.getQualifiers().isEmpty()) {
            set.add((Annotation)new AnnotationLiteral<Default>(){});
        } else {
            set.addAll(this.config.getQualifiers());
        }
        return set;
    }

    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public String getName() {
        return "entitymanagerfactory(" + this.config.getQualifiers() + ")";
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public Class<?> getBeanClass() {
        return EntityManagerFactory.class;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }
}

