/*
 * Decompiled with CFR 0.152.
 */
package io.rudin.cdi.entitymanager.bean;

import io.rudin.cdi.entitymanager.api.PersistenceConfiguration;
import io.rudin.cdi.entitymanager.bean.EntityManagerFactoryBean;
import io.rudin.cdi.entitymanager.bean.PersistenceStatusBean;
import io.rudin.cdi.entitymanager.config.PersistenceContextConfiguration;
import io.rudin.cdi.entitymanager.status.PersistenceStatusImpl;
import io.rudin.cdi.entitymanager.store.EntityManagerStore;
import io.rudin.cdi.entitymanager.store.UnitStore;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.AnnotationLiteral;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagerBean
implements Bean<EntityManager> {
    private static final Logger logger = LoggerFactory.getLogger(EntityManagerBean.class);
    private final BeanManager bm;
    private final PersistenceStatusBean statusBean;
    private final EntityManagerFactoryBean factoryBean;
    private final PersistenceContextConfiguration config;
    private PersistenceConfiguration configuration;

    public EntityManagerBean(BeanManager bm, PersistenceContextConfiguration config, EntityManagerFactoryBean factoryBean, PersistenceStatusBean statusBean) {
        this.bm = bm;
        this.config = config;
        this.factoryBean = factoryBean;
        this.statusBean = statusBean;
    }

    public EntityManager create(CreationalContext<EntityManager> creationalContext) {
        EntityManagerFactory emf = (EntityManagerFactory)this.bm.getReference((Bean)this.factoryBean, EntityManagerFactory.class, creationalContext);
        PersistenceStatusImpl status = (PersistenceStatusImpl)this.bm.getReference((Bean)this.statusBean, PersistenceStatusImpl.class, creationalContext);
        Annotation[] qualifiers = this.config.getQualifiers().toArray(new Annotation[this.config.getQualifiers().size()]);
        Set beans = this.bm.getBeans(PersistenceConfiguration.class, qualifiers);
        this.configuration = (PersistenceConfiguration)this.bm.getReference((Bean)beans.iterator().next(), PersistenceConfiguration.class, creationalContext);
        logger.debug("Got config class: {}", (Object)this.configuration.getClass().getName());
        EntityManagerStore store = UnitStore.get(this.configuration.getUnitName());
        EntityManager entityManager = store.get();
        if (entityManager == null) {
            status.incrementOpenCount(1);
            entityManager = emf.createEntityManager();
            store.set(entityManager);
            logger.debug("Created new entitymanager: {}", (Object)entityManager);
        }
        return entityManager;
    }

    public void destroy(EntityManager instance, CreationalContext<EntityManager> creationalContext) {
        PersistenceStatusImpl status = (PersistenceStatusImpl)this.bm.getReference((Bean)this.statusBean, PersistenceStatusImpl.class, creationalContext);
        EntityManagerStore store = UnitStore.get(this.configuration.getUnitName());
        EntityManager entityManager = store.get();
        if (entityManager != null && entityManager.isOpen()) {
            logger.debug("Disposed entitymanager: {}", (Object)entityManager);
            status.incrementOpenCount(-1);
            entityManager.close();
            store.set(null);
        }
    }

    public Set<Type> getTypes() {
        HashSet<Type> set = new HashSet<Type>();
        set.add((Type)((Object)Object.class));
        set.add((Type)((Object)EntityManager.class));
        return set;
    }

    public Set<Annotation> getQualifiers() {
        HashSet<Annotation> set = new HashSet<Annotation>();
        if (this.config.getQualifiers().isEmpty()) {
            set.add((Annotation)new AnnotationLiteral<Default>(){});
            set.add((Annotation)new AnnotationLiteral<Any>(){});
        } else {
            set.addAll(this.config.getQualifiers());
        }
        return set;
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public String getName() {
        return "entitymanager(" + this.config.getQualifiers() + ")";
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public Class<?> getBeanClass() {
        return EntityManagerFactory.class;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }
}

