/*
 * Decompiled with CFR 0.152.
 */
package io.rudin.cdi.entitymanager;

import io.rudin.cdi.entitymanager.api.PersistenceConfiguration;
import io.rudin.cdi.entitymanager.bean.EntityManagerBean;
import io.rudin.cdi.entitymanager.bean.EntityManagerFactoryBean;
import io.rudin.cdi.entitymanager.bean.PersistenceStatusBean;
import io.rudin.cdi.entitymanager.config.PersistenceContextConfiguration;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.inject.Qualifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagerExtension
implements Extension {
    private static final Logger logger = LoggerFactory.getLogger(EntityManagerExtension.class);
    private final List<PersistenceContextConfiguration> contextList = new ArrayList<PersistenceContextConfiguration>();

    <X extends PersistenceConfiguration> void observeType(@Observes ProcessAnnotatedType<X> pat) {
        AnnotatedType type = pat.getAnnotatedType();
        Class javaClass = type.getJavaClass();
        if (javaClass == PersistenceConfiguration.class) {
            return;
        }
        logger.debug("Found config: {}", (Object)javaClass.getName());
        Set annotations = type.getAnnotations();
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        for (Annotation a : annotations) {
            if (!this.isQualifier(a)) continue;
            qualifiers.add(a);
        }
        logger.debug("\twith qualifiers: {}", qualifiers);
        PersistenceContextConfiguration configuration = new PersistenceContextConfiguration();
        configuration.setQualifiers(qualifiers);
        this.contextList.add(configuration);
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        for (PersistenceContextConfiguration ctx : this.contextList) {
            PersistenceStatusBean statusBean = new PersistenceStatusBean(bm, ctx);
            abd.addBean((Bean)statusBean);
            EntityManagerFactoryBean factoryBean = new EntityManagerFactoryBean(bm, ctx);
            abd.addBean((Bean)factoryBean);
            EntityManagerBean entityManagerBean = new EntityManagerBean(bm, ctx, factoryBean, statusBean);
            abd.addBean((Bean)entityManagerBean);
        }
    }

    private boolean isQualifier(Annotation e) {
        return e.annotationType().getAnnotation(Qualifier.class) != null;
    }
}

