package io.rudin.cdi.entitymanager.tx;

import java.util.function.Consumer;
import java.util.function.Function;

import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;

import io.rudin.cdi.entitymanager.api.entitymanager.EntityManagerCloser;
import io.rudin.cdi.entitymanager.api.tx.TxRunner;

@Dependent
public class TxRunnerImpl implements TxRunner {

	@Inject Instance<EntityManager> emInstance;

	@Override
	public void run(Consumer<EntityManager> r) {

		try (EntityManagerCloser emc = new EntityManagerCloser(emInstance)){
			EntityManager em = emc.getEntityManager();

			EntityTransaction tx = em.getTransaction();
			try {
				tx.begin();
				r.accept(em);
				tx.commit();
			} catch (Exception e){
				tx.rollback();
				throw new IllegalArgumentException("tx-run", e);
			}
			
		}
	}

	@Override
	public <T> T query(Function<EntityManager, T> r) {

		try (EntityManagerCloser emc = new EntityManagerCloser(emInstance)){
			EntityManager em = emc.getEntityManager();
			EntityTransaction tx = em.getTransaction();

			try {
				tx.begin();
				T result = r.apply(em);
				tx.commit();
				return result;
			} catch (Exception e){
				tx.rollback();
				throw new IllegalArgumentException("tx-run", e);
			}
		}

	}

}
