package io.rudin.cdi.entitymanager.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.AnnotationLiteral;

import io.rudin.cdi.entitymanager.api.PersistenceStatus;
import io.rudin.cdi.entitymanager.config.PersistenceContextConfiguration;
import io.rudin.cdi.entitymanager.status.PersistenceStatusImpl;

public class PersistenceStatusBean implements Bean<PersistenceStatus>
{
	public PersistenceStatusBean(BeanManager bm, PersistenceContextConfiguration config)
	{
		this.config = config;
		this.status = new PersistenceStatusImpl();
	}

	private final PersistenceContextConfiguration config;
	
	private final PersistenceStatusImpl status;
	
	@Override
	public PersistenceStatus create(CreationalContext<PersistenceStatus> creationalContext)
	{
		return status;
	}

	@Override
	public void destroy(PersistenceStatus instance, CreationalContext<PersistenceStatus> creationalContext)
	{
		//No-op
	}

	@Override
	public Set<Type> getTypes()
	{
		Set<Type> set = new HashSet<>();
		set.add(Object.class);
		set.add(PersistenceStatus.class);
		set.add(PersistenceStatusImpl.class);

		return set;
	}
	
	@SuppressWarnings("serial")
	@Override
	public Set<Annotation> getQualifiers() {
		Set<Annotation> set = new HashSet<>();
		
		if (config.getQualifiers().isEmpty())
		{
			set.add(new AnnotationLiteral<Default>() {});
			set.add(new AnnotationLiteral<Any>() {});
		}
		else
			set.addAll(config.getQualifiers());

		return set;
	}

	@Override
	public Class<? extends Annotation> getScope() {
		return Dependent.class;
	}

	@Override
	public String getName() {
		return "persistencestatusimpl("+config.getQualifiers()+")";
	}

	@Override
	public Set<Class<? extends Annotation>> getStereotypes() {
		return Collections.emptySet();
	}

	@Override
	public boolean isAlternative() {
		return false;
	}

	@Override
	public Class<?> getBeanClass() {
		return PersistenceStatus.class;
	}

	@Override
	public Set<InjectionPoint> getInjectionPoints() {
		return Collections.emptySet();
	}

	@Override
	public boolean isNullable() {
		return false;
	}

}
