package io.rudin.cdi.entitymanager.api.crud;

import java.io.Serializable;
import java.util.List;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

@Produces(MediaType.APPLICATION_JSON)
@Consumes(MediaType.APPLICATION_JSON)
public abstract class CRUDApi<E, K extends Serializable>
{

	@Inject CRUD<E, K> crud;
	
	@GET
	@Path("/")
	public List<E> getAll() {
		return crud.findAll();
	}

	@GET
	@Path("/{id: .*}")
	public E getById(@PathParam("id") K id) {
		return crud.findById(id);
	}

	@POST
	@Path("/")
	public E create(E item) {
		return crud.save(item);
	}

	@PUT
	@Path("/{id: .*}")
	public E update(@PathParam("id") K id, E item) {
		return crud.save(item);
	}

	@DELETE
	@Path("/{id: .*}")
	public boolean remove(@PathParam("id") K id) {
		E entity = getById(id);
		crud.remove(entity);
		return true;
	}
	

}