/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.sample.converter;

import io.rocketbase.sample.converter.EmployeeConverter;
import io.rocketbase.sample.dto.employee.EmployeeRead;
import io.rocketbase.sample.dto.employee.EmployeeWrite;
import io.rocketbase.sample.model.EmployeeEntity;
import org.springframework.stereotype.Component;

@Component
public class EmployeeConverterImpl
extends EmployeeConverter {
    @Override
    public EmployeeRead fromEntity(EmployeeEntity entity) {
        if (entity == null) {
            return null;
        }
        EmployeeRead employeeRead = new EmployeeRead();
        employeeRead.setId(entity.getId());
        employeeRead.setFirstName(entity.getFirstName());
        employeeRead.setLastName(entity.getLastName());
        employeeRead.setDateOfBirth(entity.getDateOfBirth());
        employeeRead.setFemale(entity.isFemale());
        employeeRead.setEmail(entity.getEmail());
        employeeRead.setCompany(this.convertCompanyId(entity.getCompanyId()));
        return employeeRead;
    }

    @Override
    public EmployeeEntity newEntity(EmployeeWrite workspace) {
        if (workspace == null) {
            return null;
        }
        EmployeeEntity employeeEntity = new EmployeeEntity();
        employeeEntity.setFirstName(workspace.getFirstName());
        employeeEntity.setLastName(workspace.getLastName());
        employeeEntity.setDateOfBirth(workspace.getDateOfBirth());
        employeeEntity.setFemale(workspace.isFemale());
        employeeEntity.setEmail(workspace.getEmail());
        return employeeEntity;
    }

    @Override
    public EmployeeEntity updateEntityFromEdit(EmployeeWrite write, EmployeeEntity entity) {
        if (write == null) {
            return entity;
        }
        entity.setFirstName(write.getFirstName());
        entity.setLastName(write.getLastName());
        entity.setDateOfBirth(write.getDateOfBirth());
        entity.setFemale(write.isFemale());
        entity.setEmail(write.getEmail());
        return entity;
    }
}

